// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Reservations.Models
{
    /// <summary> Represent the term of reservation. </summary>
    public readonly partial struct ReservationTerm : IEquatable<ReservationTerm>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReservationTerm"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReservationTerm(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string P1YValue = "P1Y";
        private const string P3YValue = "P3Y";
        private const string P5YValue = "P5Y";

        /// <summary> P1Y. </summary>
        public static ReservationTerm P1Y { get; } = new ReservationTerm(P1YValue);
        /// <summary> P3Y. </summary>
        public static ReservationTerm P3Y { get; } = new ReservationTerm(P3YValue);
        /// <summary> P5Y. </summary>
        public static ReservationTerm P5Y { get; } = new ReservationTerm(P5YValue);
        /// <summary> Determines if two <see cref="ReservationTerm"/> values are the same. </summary>
        public static bool operator ==(ReservationTerm left, ReservationTerm right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReservationTerm"/> values are not the same. </summary>
        public static bool operator !=(ReservationTerm left, ReservationTerm right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReservationTerm"/>. </summary>
        public static implicit operator ReservationTerm(string value) => new ReservationTerm(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReservationTerm other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReservationTerm other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
