// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Reservations.Models
{
    /// <summary> Resource Provider type to be reserved. </summary>
    public readonly partial struct ReservationKind : IEquatable<ReservationKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReservationKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReservationKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftComputeValue = "Microsoft.Compute";

        /// <summary> Microsoft.Compute. </summary>
        public static ReservationKind MicrosoftCompute { get; } = new ReservationKind(MicrosoftComputeValue);
        /// <summary> Determines if two <see cref="ReservationKind"/> values are the same. </summary>
        public static bool operator ==(ReservationKind left, ReservationKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReservationKind"/> values are not the same. </summary>
        public static bool operator !=(ReservationKind left, ReservationKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReservationKind"/>. </summary>
        public static implicit operator ReservationKind(string value) => new ReservationKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReservationKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReservationKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
