// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Reservations.Models
{
    /// <summary> Error code describing the reason that service is not able to process the incoming request. </summary>
    public readonly partial struct ReservationErrorResponseCode : IEquatable<ReservationErrorResponseCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReservationErrorResponseCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReservationErrorResponseCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string InternalServerErrorValue = "InternalServerError";
        private const string ServerTimeoutValue = "ServerTimeout";
        private const string AuthorizationFailedValue = "AuthorizationFailed";
        private const string BadRequestValue = "BadRequest";
        private const string ClientCertificateThumbprintNotSetValue = "ClientCertificateThumbprintNotSet";
        private const string InvalidRequestContentValue = "InvalidRequestContent";
        private const string OperationFailedValue = "OperationFailed";
        private const string HttpMethodNotSupportedValue = "HttpMethodNotSupported";
        private const string InvalidRequestUriValue = "InvalidRequestUri";
        private const string MissingTenantIdValue = "MissingTenantId";
        private const string InvalidTenantIdValue = "InvalidTenantId";
        private const string InvalidReservationOrderIdValue = "InvalidReservationOrderId";
        private const string InvalidReservationIdValue = "InvalidReservationId";
        private const string ReservationIdNotInReservationOrderValue = "ReservationIdNotInReservationOrder";
        private const string ReservationOrderNotFoundValue = "ReservationOrderNotFound";
        private const string InvalidSubscriptionIdValue = "InvalidSubscriptionId";
        private const string InvalidAccessTokenValue = "InvalidAccessToken";
        private const string InvalidLocationIdValue = "InvalidLocationId";
        private const string UnauthenticatedRequestsThrottledValue = "UnauthenticatedRequestsThrottled";
        private const string InvalidHealthCheckTypeValue = "InvalidHealthCheckType";
        private const string ForbiddenValue = "Forbidden";
        private const string BillingScopeIdCannotBeChangedValue = "BillingScopeIdCannotBeChanged";
        private const string AppliedScopesNotAssociatedWithCommerceAccountValue = "AppliedScopesNotAssociatedWithCommerceAccount";
        private const string PatchValuesSameAsExistingValue = "PatchValuesSameAsExisting";
        private const string RoleAssignmentCreationFailedValue = "RoleAssignmentCreationFailed";
        private const string ReservationOrderCreationFailedValue = "ReservationOrderCreationFailed";
        private const string ReservationOrderNotEnabledValue = "ReservationOrderNotEnabled";
        private const string CapacityUpdateScopesFailedValue = "CapacityUpdateScopesFailed";
        private const string UnsupportedReservationTermValue = "UnsupportedReservationTerm";
        private const string ReservationOrderIdAlreadyExistsValue = "ReservationOrderIdAlreadyExists";
        private const string RiskCheckFailedValue = "RiskCheckFailed";
        private const string CreateQuoteFailedValue = "CreateQuoteFailed";
        private const string ActivateQuoteFailedValue = "ActivateQuoteFailed";
        private const string NonsupportedAccountIdValue = "NonsupportedAccountId";
        private const string PaymentInstrumentNotFoundValue = "PaymentInstrumentNotFound";
        private const string MissingAppliedScopesForSingleValue = "MissingAppliedScopesForSingle";
        private const string NoValidReservationsToReRateValue = "NoValidReservationsToReRate";
        private const string ReRateOnlyAllowedForEAValue = "ReRateOnlyAllowedForEA";
        private const string OperationCannotBePerformedInCurrentStateValue = "OperationCannotBePerformedInCurrentState";
        private const string InvalidSingleAppliedScopesCountValue = "InvalidSingleAppliedScopesCount";
        private const string InvalidFulfillmentRequestParametersValue = "InvalidFulfillmentRequestParameters";
        private const string NotSupportedCountryValue = "NotSupportedCountry";
        private const string InvalidRefundQuantityValue = "InvalidRefundQuantity";
        private const string PurchaseErrorValue = "PurchaseError";
        private const string BillingCustomerInputErrorValue = "BillingCustomerInputError";
        private const string BillingPaymentInstrumentSoftErrorValue = "BillingPaymentInstrumentSoftError";
        private const string BillingPaymentInstrumentHardErrorValue = "BillingPaymentInstrumentHardError";
        private const string BillingTransientErrorValue = "BillingTransientError";
        private const string BillingErrorValue = "BillingError";
        private const string FulfillmentConfigurationErrorValue = "FulfillmentConfigurationError";
        private const string FulfillmentOutOfStockErrorValue = "FulfillmentOutOfStockError";
        private const string FulfillmentTransientErrorValue = "FulfillmentTransientError";
        private const string FulfillmentErrorValue = "FulfillmentError";
        private const string CalculatePriceFailedValue = "CalculatePriceFailed";
        private const string AppliedScopesSameAsExistingValue = "AppliedScopesSameAsExisting";
        private const string SelfServiceRefundNotSupportedValue = "SelfServiceRefundNotSupported";
        private const string RefundLimitExceededValue = "RefundLimitExceeded";

        /// <summary> NotSpecified. </summary>
        public static ReservationErrorResponseCode NotSpecified { get; } = new ReservationErrorResponseCode(NotSpecifiedValue);
        /// <summary> InternalServerError. </summary>
        public static ReservationErrorResponseCode InternalServerError { get; } = new ReservationErrorResponseCode(InternalServerErrorValue);
        /// <summary> ServerTimeout. </summary>
        public static ReservationErrorResponseCode ServerTimeout { get; } = new ReservationErrorResponseCode(ServerTimeoutValue);
        /// <summary> AuthorizationFailed. </summary>
        public static ReservationErrorResponseCode AuthorizationFailed { get; } = new ReservationErrorResponseCode(AuthorizationFailedValue);
        /// <summary> BadRequest. </summary>
        public static ReservationErrorResponseCode BadRequest { get; } = new ReservationErrorResponseCode(BadRequestValue);
        /// <summary> ClientCertificateThumbprintNotSet. </summary>
        public static ReservationErrorResponseCode ClientCertificateThumbprintNotSet { get; } = new ReservationErrorResponseCode(ClientCertificateThumbprintNotSetValue);
        /// <summary> InvalidRequestContent. </summary>
        public static ReservationErrorResponseCode InvalidRequestContent { get; } = new ReservationErrorResponseCode(InvalidRequestContentValue);
        /// <summary> OperationFailed. </summary>
        public static ReservationErrorResponseCode OperationFailed { get; } = new ReservationErrorResponseCode(OperationFailedValue);
        /// <summary> HttpMethodNotSupported. </summary>
        public static ReservationErrorResponseCode HttpMethodNotSupported { get; } = new ReservationErrorResponseCode(HttpMethodNotSupportedValue);
        /// <summary> InvalidRequestUri. </summary>
        public static ReservationErrorResponseCode InvalidRequestUri { get; } = new ReservationErrorResponseCode(InvalidRequestUriValue);
        /// <summary> MissingTenantId. </summary>
        public static ReservationErrorResponseCode MissingTenantId { get; } = new ReservationErrorResponseCode(MissingTenantIdValue);
        /// <summary> InvalidTenantId. </summary>
        public static ReservationErrorResponseCode InvalidTenantId { get; } = new ReservationErrorResponseCode(InvalidTenantIdValue);
        /// <summary> InvalidReservationOrderId. </summary>
        public static ReservationErrorResponseCode InvalidReservationOrderId { get; } = new ReservationErrorResponseCode(InvalidReservationOrderIdValue);
        /// <summary> InvalidReservationId. </summary>
        public static ReservationErrorResponseCode InvalidReservationId { get; } = new ReservationErrorResponseCode(InvalidReservationIdValue);
        /// <summary> ReservationIdNotInReservationOrder. </summary>
        public static ReservationErrorResponseCode ReservationIdNotInReservationOrder { get; } = new ReservationErrorResponseCode(ReservationIdNotInReservationOrderValue);
        /// <summary> ReservationOrderNotFound. </summary>
        public static ReservationErrorResponseCode ReservationOrderNotFound { get; } = new ReservationErrorResponseCode(ReservationOrderNotFoundValue);
        /// <summary> InvalidSubscriptionId. </summary>
        public static ReservationErrorResponseCode InvalidSubscriptionId { get; } = new ReservationErrorResponseCode(InvalidSubscriptionIdValue);
        /// <summary> InvalidAccessToken. </summary>
        public static ReservationErrorResponseCode InvalidAccessToken { get; } = new ReservationErrorResponseCode(InvalidAccessTokenValue);
        /// <summary> InvalidLocationId. </summary>
        public static ReservationErrorResponseCode InvalidLocationId { get; } = new ReservationErrorResponseCode(InvalidLocationIdValue);
        /// <summary> UnauthenticatedRequestsThrottled. </summary>
        public static ReservationErrorResponseCode UnauthenticatedRequestsThrottled { get; } = new ReservationErrorResponseCode(UnauthenticatedRequestsThrottledValue);
        /// <summary> InvalidHealthCheckType. </summary>
        public static ReservationErrorResponseCode InvalidHealthCheckType { get; } = new ReservationErrorResponseCode(InvalidHealthCheckTypeValue);
        /// <summary> Forbidden. </summary>
        public static ReservationErrorResponseCode Forbidden { get; } = new ReservationErrorResponseCode(ForbiddenValue);
        /// <summary> BillingScopeIdCannotBeChanged. </summary>
        public static ReservationErrorResponseCode BillingScopeIdCannotBeChanged { get; } = new ReservationErrorResponseCode(BillingScopeIdCannotBeChangedValue);
        /// <summary> AppliedScopesNotAssociatedWithCommerceAccount. </summary>
        public static ReservationErrorResponseCode AppliedScopesNotAssociatedWithCommerceAccount { get; } = new ReservationErrorResponseCode(AppliedScopesNotAssociatedWithCommerceAccountValue);
        /// <summary> PatchValuesSameAsExisting. </summary>
        public static ReservationErrorResponseCode PatchValuesSameAsExisting { get; } = new ReservationErrorResponseCode(PatchValuesSameAsExistingValue);
        /// <summary> RoleAssignmentCreationFailed. </summary>
        public static ReservationErrorResponseCode RoleAssignmentCreationFailed { get; } = new ReservationErrorResponseCode(RoleAssignmentCreationFailedValue);
        /// <summary> ReservationOrderCreationFailed. </summary>
        public static ReservationErrorResponseCode ReservationOrderCreationFailed { get; } = new ReservationErrorResponseCode(ReservationOrderCreationFailedValue);
        /// <summary> ReservationOrderNotEnabled. </summary>
        public static ReservationErrorResponseCode ReservationOrderNotEnabled { get; } = new ReservationErrorResponseCode(ReservationOrderNotEnabledValue);
        /// <summary> CapacityUpdateScopesFailed. </summary>
        public static ReservationErrorResponseCode CapacityUpdateScopesFailed { get; } = new ReservationErrorResponseCode(CapacityUpdateScopesFailedValue);
        /// <summary> UnsupportedReservationTerm. </summary>
        public static ReservationErrorResponseCode UnsupportedReservationTerm { get; } = new ReservationErrorResponseCode(UnsupportedReservationTermValue);
        /// <summary> ReservationOrderIdAlreadyExists. </summary>
        public static ReservationErrorResponseCode ReservationOrderIdAlreadyExists { get; } = new ReservationErrorResponseCode(ReservationOrderIdAlreadyExistsValue);
        /// <summary> RiskCheckFailed. </summary>
        public static ReservationErrorResponseCode RiskCheckFailed { get; } = new ReservationErrorResponseCode(RiskCheckFailedValue);
        /// <summary> CreateQuoteFailed. </summary>
        public static ReservationErrorResponseCode CreateQuoteFailed { get; } = new ReservationErrorResponseCode(CreateQuoteFailedValue);
        /// <summary> ActivateQuoteFailed. </summary>
        public static ReservationErrorResponseCode ActivateQuoteFailed { get; } = new ReservationErrorResponseCode(ActivateQuoteFailedValue);
        /// <summary> NonsupportedAccountId. </summary>
        public static ReservationErrorResponseCode NonsupportedAccountId { get; } = new ReservationErrorResponseCode(NonsupportedAccountIdValue);
        /// <summary> PaymentInstrumentNotFound. </summary>
        public static ReservationErrorResponseCode PaymentInstrumentNotFound { get; } = new ReservationErrorResponseCode(PaymentInstrumentNotFoundValue);
        /// <summary> MissingAppliedScopesForSingle. </summary>
        public static ReservationErrorResponseCode MissingAppliedScopesForSingle { get; } = new ReservationErrorResponseCode(MissingAppliedScopesForSingleValue);
        /// <summary> NoValidReservationsToReRate. </summary>
        public static ReservationErrorResponseCode NoValidReservationsToReRate { get; } = new ReservationErrorResponseCode(NoValidReservationsToReRateValue);
        /// <summary> ReRateOnlyAllowedForEA. </summary>
        public static ReservationErrorResponseCode ReRateOnlyAllowedForEA { get; } = new ReservationErrorResponseCode(ReRateOnlyAllowedForEAValue);
        /// <summary> OperationCannotBePerformedInCurrentState. </summary>
        public static ReservationErrorResponseCode OperationCannotBePerformedInCurrentState { get; } = new ReservationErrorResponseCode(OperationCannotBePerformedInCurrentStateValue);
        /// <summary> InvalidSingleAppliedScopesCount. </summary>
        public static ReservationErrorResponseCode InvalidSingleAppliedScopesCount { get; } = new ReservationErrorResponseCode(InvalidSingleAppliedScopesCountValue);
        /// <summary> InvalidFulfillmentRequestParameters. </summary>
        public static ReservationErrorResponseCode InvalidFulfillmentRequestParameters { get; } = new ReservationErrorResponseCode(InvalidFulfillmentRequestParametersValue);
        /// <summary> NotSupportedCountry. </summary>
        public static ReservationErrorResponseCode NotSupportedCountry { get; } = new ReservationErrorResponseCode(NotSupportedCountryValue);
        /// <summary> InvalidRefundQuantity. </summary>
        public static ReservationErrorResponseCode InvalidRefundQuantity { get; } = new ReservationErrorResponseCode(InvalidRefundQuantityValue);
        /// <summary> PurchaseError. </summary>
        public static ReservationErrorResponseCode PurchaseError { get; } = new ReservationErrorResponseCode(PurchaseErrorValue);
        /// <summary> BillingCustomerInputError. </summary>
        public static ReservationErrorResponseCode BillingCustomerInputError { get; } = new ReservationErrorResponseCode(BillingCustomerInputErrorValue);
        /// <summary> BillingPaymentInstrumentSoftError. </summary>
        public static ReservationErrorResponseCode BillingPaymentInstrumentSoftError { get; } = new ReservationErrorResponseCode(BillingPaymentInstrumentSoftErrorValue);
        /// <summary> BillingPaymentInstrumentHardError. </summary>
        public static ReservationErrorResponseCode BillingPaymentInstrumentHardError { get; } = new ReservationErrorResponseCode(BillingPaymentInstrumentHardErrorValue);
        /// <summary> BillingTransientError. </summary>
        public static ReservationErrorResponseCode BillingTransientError { get; } = new ReservationErrorResponseCode(BillingTransientErrorValue);
        /// <summary> BillingError. </summary>
        public static ReservationErrorResponseCode BillingError { get; } = new ReservationErrorResponseCode(BillingErrorValue);
        /// <summary> FulfillmentConfigurationError. </summary>
        public static ReservationErrorResponseCode FulfillmentConfigurationError { get; } = new ReservationErrorResponseCode(FulfillmentConfigurationErrorValue);
        /// <summary> FulfillmentOutOfStockError. </summary>
        public static ReservationErrorResponseCode FulfillmentOutOfStockError { get; } = new ReservationErrorResponseCode(FulfillmentOutOfStockErrorValue);
        /// <summary> FulfillmentTransientError. </summary>
        public static ReservationErrorResponseCode FulfillmentTransientError { get; } = new ReservationErrorResponseCode(FulfillmentTransientErrorValue);
        /// <summary> FulfillmentError. </summary>
        public static ReservationErrorResponseCode FulfillmentError { get; } = new ReservationErrorResponseCode(FulfillmentErrorValue);
        /// <summary> CalculatePriceFailed. </summary>
        public static ReservationErrorResponseCode CalculatePriceFailed { get; } = new ReservationErrorResponseCode(CalculatePriceFailedValue);
        /// <summary> AppliedScopesSameAsExisting. </summary>
        public static ReservationErrorResponseCode AppliedScopesSameAsExisting { get; } = new ReservationErrorResponseCode(AppliedScopesSameAsExistingValue);
        /// <summary> SelfServiceRefundNotSupported. </summary>
        public static ReservationErrorResponseCode SelfServiceRefundNotSupported { get; } = new ReservationErrorResponseCode(SelfServiceRefundNotSupportedValue);
        /// <summary> RefundLimitExceeded. </summary>
        public static ReservationErrorResponseCode RefundLimitExceeded { get; } = new ReservationErrorResponseCode(RefundLimitExceededValue);
        /// <summary> Determines if two <see cref="ReservationErrorResponseCode"/> values are the same. </summary>
        public static bool operator ==(ReservationErrorResponseCode left, ReservationErrorResponseCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReservationErrorResponseCode"/> values are not the same. </summary>
        public static bool operator !=(ReservationErrorResponseCode left, ReservationErrorResponseCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReservationErrorResponseCode"/>. </summary>
        public static implicit operator ReservationErrorResponseCode(string value) => new ReservationErrorResponseCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReservationErrorResponseCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReservationErrorResponseCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
