// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Reservations.Models
{
    /// <summary> The request for reservation patch. </summary>
    public partial class ReservationDetailPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ReservationDetailPatch"/>. </summary>
        public ReservationDetailPatch()
        {
            AppliedScopes = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ReservationDetailPatch"/>. </summary>
        /// <param name="appliedScopeType"> Type of the Applied Scope. </param>
        /// <param name="appliedScopes"> List of the subscriptions that the benefit will be applied. Do not specify if AppliedScopeType is Shared. This property will be deprecated and replaced by appliedScopeProperties instead for Single AppliedScopeType. </param>
        /// <param name="appliedScopeProperties"> Properties specific to applied scope type. Not required if not applicable. Required and need to provide tenantId and managementGroupId if AppliedScopeType is ManagementGroup. </param>
        /// <param name="instanceFlexibility"> Turning this on will apply the reservation discount to other VMs in the same VM size group. Only specify for VirtualMachines reserved resource type. </param>
        /// <param name="name"> Display name of the reservation. </param>
        /// <param name="isRenewEnabled"> Setting this to true will automatically purchase a new reservation on the expiration date time. </param>
        /// <param name="renewProperties"></param>
        /// <param name="reviewOn"> This is the date-time when the Azure hybrid benefit needs to be reviewed. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ReservationDetailPatch(AppliedScopeType? appliedScopeType, IList<string> appliedScopes, AppliedScopeProperties appliedScopeProperties, InstanceFlexibility? instanceFlexibility, string name, bool? isRenewEnabled, PatchPropertiesRenewProperties renewProperties, DateTimeOffset? reviewOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AppliedScopeType = appliedScopeType;
            AppliedScopes = appliedScopes;
            AppliedScopeProperties = appliedScopeProperties;
            InstanceFlexibility = instanceFlexibility;
            Name = name;
            IsRenewEnabled = isRenewEnabled;
            RenewProperties = renewProperties;
            ReviewOn = reviewOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Type of the Applied Scope. </summary>
        public AppliedScopeType? AppliedScopeType { get; set; }
        /// <summary> List of the subscriptions that the benefit will be applied. Do not specify if AppliedScopeType is Shared. This property will be deprecated and replaced by appliedScopeProperties instead for Single AppliedScopeType. </summary>
        public IList<string> AppliedScopes { get; }
        /// <summary> Properties specific to applied scope type. Not required if not applicable. Required and need to provide tenantId and managementGroupId if AppliedScopeType is ManagementGroup. </summary>
        public AppliedScopeProperties AppliedScopeProperties { get; set; }
        /// <summary> Turning this on will apply the reservation discount to other VMs in the same VM size group. Only specify for VirtualMachines reserved resource type. </summary>
        public InstanceFlexibility? InstanceFlexibility { get; set; }
        /// <summary> Display name of the reservation. </summary>
        public string Name { get; set; }
        /// <summary> Setting this to true will automatically purchase a new reservation on the expiration date time. </summary>
        public bool? IsRenewEnabled { get; set; }
        /// <summary> Gets or sets the renew properties. </summary>
        internal PatchPropertiesRenewProperties RenewProperties { get; set; }
        /// <summary> The request for reservation purchase. </summary>
        public ReservationPurchaseContent RenewPurchaseProperties
        {
            get => RenewProperties is null ? default : RenewProperties.PurchaseProperties;
            set
            {
                if (RenewProperties is null)
                    RenewProperties = new PatchPropertiesRenewProperties();
                RenewProperties.PurchaseProperties = value;
            }
        }

        /// <summary> This is the date-time when the Azure hybrid benefit needs to be reviewed. </summary>
        public DateTimeOffset? ReviewOn { get; set; }
    }
}
