// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Reservations.Models
{
    public partial class ReservationCatalogMsrp : IUtf8JsonSerializable, IJsonModel<ReservationCatalogMsrp>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ReservationCatalogMsrp>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ReservationCatalogMsrp>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ReservationCatalogMsrp>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ReservationCatalogMsrp)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(P1Y))
            {
                writer.WritePropertyName("p1Y"u8);
                writer.WriteObjectValue(P1Y, options);
            }
            if (Optional.IsDefined(P3Y))
            {
                writer.WritePropertyName("p3Y"u8);
                writer.WriteObjectValue(P3Y, options);
            }
            if (Optional.IsDefined(P5Y))
            {
                writer.WritePropertyName("p5Y"u8);
                writer.WriteObjectValue(P5Y, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ReservationCatalogMsrp IJsonModel<ReservationCatalogMsrp>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ReservationCatalogMsrp>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ReservationCatalogMsrp)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeReservationCatalogMsrp(document.RootElement, options);
        }

        internal static ReservationCatalogMsrp DeserializeReservationCatalogMsrp(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            PurchasePrice p1Y = default;
            PurchasePrice p3Y = default;
            PurchasePrice p5Y = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("p1Y"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    p1Y = PurchasePrice.DeserializePurchasePrice(property.Value, options);
                    continue;
                }
                if (property.NameEquals("p3Y"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    p3Y = PurchasePrice.DeserializePurchasePrice(property.Value, options);
                    continue;
                }
                if (property.NameEquals("p5Y"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    p5Y = PurchasePrice.DeserializePurchasePrice(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ReservationCatalogMsrp(p1Y, p3Y, p5Y, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ReservationCatalogMsrp>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ReservationCatalogMsrp>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ReservationCatalogMsrp)} does not support writing '{options.Format}' format.");
            }
        }

        ReservationCatalogMsrp IPersistableModel<ReservationCatalogMsrp>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ReservationCatalogMsrp>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeReservationCatalogMsrp(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ReservationCatalogMsrp)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ReservationCatalogMsrp>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
