// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Reservations.Models
{
    /// <summary> Properties needed for calculate refund including the scope and the reservation to be returned. </summary>
    public partial class ReservationCalculateRefundRequestProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ReservationCalculateRefundRequestProperties"/>. </summary>
        public ReservationCalculateRefundRequestProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ReservationCalculateRefundRequestProperties"/>. </summary>
        /// <param name="scope"> The scope of the refund, e.g. Reservation. </param>
        /// <param name="reservationToReturn"> Reservation to return. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ReservationCalculateRefundRequestProperties(string scope, ReservationToReturn reservationToReturn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Scope = scope;
            ReservationToReturn = reservationToReturn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The scope of the refund, e.g. Reservation. </summary>
        public string Scope { get; set; }
        /// <summary> Reservation to return. </summary>
        public ReservationToReturn ReservationToReturn { get; set; }
    }
}
