// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Reservations.Models
{
    /// <summary> Describes whether the payment is completed, failed, cancelled or scheduled in the future. </summary>
    public readonly partial struct PaymentStatus : IEquatable<PaymentStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PaymentStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PaymentStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string ScheduledValue = "Scheduled";
        private const string CancelledValue = "Cancelled";

        /// <summary> Succeeded. </summary>
        public static PaymentStatus Succeeded { get; } = new PaymentStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static PaymentStatus Failed { get; } = new PaymentStatus(FailedValue);
        /// <summary> Scheduled. </summary>
        public static PaymentStatus Scheduled { get; } = new PaymentStatus(ScheduledValue);
        /// <summary> Cancelled. </summary>
        public static PaymentStatus Cancelled { get; } = new PaymentStatus(CancelledValue);
        /// <summary> Determines if two <see cref="PaymentStatus"/> values are the same. </summary>
        public static bool operator ==(PaymentStatus left, PaymentStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PaymentStatus"/> values are not the same. </summary>
        public static bool operator !=(PaymentStatus left, PaymentStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PaymentStatus"/>. </summary>
        public static implicit operator PaymentStatus(string value) => new PaymentStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PaymentStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PaymentStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
