// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Reservations.Models
{
    /// <summary> Information about payment related to a reservation order. </summary>
    public partial class PaymentDetail
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PaymentDetail"/>. </summary>
        internal PaymentDetail()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PaymentDetail"/>. </summary>
        /// <param name="dueOn"> Date when the payment needs to be done. </param>
        /// <param name="payOn"> Date when the transaction is completed. Is null when it is scheduled. </param>
        /// <param name="pricingCurrencyTotal"> Amount in pricing currency. Tax not included. </param>
        /// <param name="billingCurrencyTotal"> Amount charged in Billing currency. Tax not included. Is null for future payments. </param>
        /// <param name="billingAccount"> Shows the Account that is charged for this payment. </param>
        /// <param name="status"> Describes whether the payment is completed, failed, cancelled or scheduled in the future. </param>
        /// <param name="extendedStatusInfo"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PaymentDetail(DateTimeOffset? dueOn, DateTimeOffset? payOn, PurchasePrice pricingCurrencyTotal, PurchasePrice billingCurrencyTotal, string billingAccount, PaymentStatus? status, ExtendedStatusInfo extendedStatusInfo, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DueOn = dueOn;
            PayOn = payOn;
            PricingCurrencyTotal = pricingCurrencyTotal;
            BillingCurrencyTotal = billingCurrencyTotal;
            BillingAccount = billingAccount;
            Status = status;
            ExtendedStatusInfo = extendedStatusInfo;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Date when the payment needs to be done. </summary>
        public DateTimeOffset? DueOn { get; }
        /// <summary> Date when the transaction is completed. Is null when it is scheduled. </summary>
        public DateTimeOffset? PayOn { get; }
        /// <summary> Amount in pricing currency. Tax not included. </summary>
        public PurchasePrice PricingCurrencyTotal { get; }
        /// <summary> Amount charged in Billing currency. Tax not included. Is null for future payments. </summary>
        public PurchasePrice BillingCurrencyTotal { get; }
        /// <summary> Shows the Account that is charged for this payment. </summary>
        public string BillingAccount { get; }
        /// <summary> Describes whether the payment is completed, failed, cancelled or scheduled in the future. </summary>
        public PaymentStatus? Status { get; }
        /// <summary> Gets the extended status info. </summary>
        public ExtendedStatusInfo ExtendedStatusInfo { get; }
    }
}
