// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Reservations.Models
{
    internal partial class ExchangePolicyErrors : IUtf8JsonSerializable, IJsonModel<ExchangePolicyErrors>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ExchangePolicyErrors>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ExchangePolicyErrors>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExchangePolicyErrors>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExchangePolicyErrors)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(PolicyErrors))
            {
                if (PolicyErrors != null)
                {
                    writer.WritePropertyName("policyErrors"u8);
                    writer.WriteStartArray();
                    foreach (var item in PolicyErrors)
                    {
                        writer.WriteObjectValue(item, options);
                    }
                    writer.WriteEndArray();
                }
                else
                {
                    writer.WriteNull("policyErrors");
                }
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ExchangePolicyErrors IJsonModel<ExchangePolicyErrors>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExchangePolicyErrors>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExchangePolicyErrors)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeExchangePolicyErrors(document.RootElement, options);
        }

        internal static ExchangePolicyErrors DeserializeExchangePolicyErrors(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<ExchangePolicyError> policyErrors = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("policyErrors"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        policyErrors = null;
                        continue;
                    }
                    List<ExchangePolicyError> array = new List<ExchangePolicyError>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ExchangePolicyError.DeserializeExchangePolicyError(item, options));
                    }
                    policyErrors = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ExchangePolicyErrors(policyErrors ?? new ChangeTrackingList<ExchangePolicyError>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ExchangePolicyErrors>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExchangePolicyErrors>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ExchangePolicyErrors)} does not support writing '{options.Format}' format.");
            }
        }

        ExchangePolicyErrors IPersistableModel<ExchangePolicyErrors>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExchangePolicyErrors>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeExchangePolicyErrors(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ExchangePolicyErrors)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ExchangePolicyErrors>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
