// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Reservations.Models
{
    /// <summary> Status of the operation. </summary>
    public readonly partial struct ExchangeOperationResultStatus : IEquatable<ExchangeOperationResultStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExchangeOperationResultStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExchangeOperationResultStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CancelledValue = "Cancelled";
        private const string PendingRefundsValue = "PendingRefunds";
        private const string PendingPurchasesValue = "PendingPurchases";

        /// <summary> Succeeded. </summary>
        public static ExchangeOperationResultStatus Succeeded { get; } = new ExchangeOperationResultStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static ExchangeOperationResultStatus Failed { get; } = new ExchangeOperationResultStatus(FailedValue);
        /// <summary> Cancelled. </summary>
        public static ExchangeOperationResultStatus Cancelled { get; } = new ExchangeOperationResultStatus(CancelledValue);
        /// <summary> PendingRefunds. </summary>
        public static ExchangeOperationResultStatus PendingRefunds { get; } = new ExchangeOperationResultStatus(PendingRefundsValue);
        /// <summary> PendingPurchases. </summary>
        public static ExchangeOperationResultStatus PendingPurchases { get; } = new ExchangeOperationResultStatus(PendingPurchasesValue);
        /// <summary> Determines if two <see cref="ExchangeOperationResultStatus"/> values are the same. </summary>
        public static bool operator ==(ExchangeOperationResultStatus left, ExchangeOperationResultStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExchangeOperationResultStatus"/> values are not the same. </summary>
        public static bool operator !=(ExchangeOperationResultStatus left, ExchangeOperationResultStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExchangeOperationResultStatus"/>. </summary>
        public static implicit operator ExchangeOperationResultStatus(string value) => new ExchangeOperationResultStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExchangeOperationResultStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExchangeOperationResultStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
