// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Reservations.Models
{
    /// <summary> Change directory result for reservation order or reservation. </summary>
    public partial class ChangeDirectoryResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ChangeDirectoryResult"/>. </summary>
        internal ChangeDirectoryResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ChangeDirectoryResult"/>. </summary>
        /// <param name="id"> Identifier of the reservation order or reservation. </param>
        /// <param name="name"> Name of the reservation order or reservation. </param>
        /// <param name="isSucceeded"> True if change directory operation succeeded on this reservation order or reservation. </param>
        /// <param name="error"> Error reason if operation failed. Null otherwise. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ChangeDirectoryResult(Guid? id, string name, bool? isSucceeded, string error, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Name = name;
            IsSucceeded = isSucceeded;
            Error = error;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Identifier of the reservation order or reservation. </summary>
        public Guid? Id { get; }
        /// <summary> Name of the reservation order or reservation. </summary>
        public string Name { get; }
        /// <summary> True if change directory operation succeeded on this reservation order or reservation. </summary>
        public bool? IsSucceeded { get; }
        /// <summary> Error reason if operation failed. Null otherwise. </summary>
        public string Error { get; }
    }
}
