// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Reservations.Models
{
    /// <summary> CalculateExchange operation result. </summary>
    public partial class CalculateExchangeResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CalculateExchangeResult"/>. </summary>
        internal CalculateExchangeResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CalculateExchangeResult"/>. </summary>
        /// <param name="id"> It should match what is used to GET the operation result. </param>
        /// <param name="name"> It must match the last segment of the id field, and will typically be a GUID / system generated value. </param>
        /// <param name="status"> Status of the operation. </param>
        /// <param name="properties"> CalculateExchange response properties. </param>
        /// <param name="error"> Required if status == failed or status == canceled. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CalculateExchangeResult(ResourceIdentifier id, string name, CalculateExchangeOperationResultStatus? status, CalculateExchangeResultProperties properties, OperationResultError error, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Name = name;
            Status = status;
            Properties = properties;
            Error = error;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> It should match what is used to GET the operation result. </summary>
        public ResourceIdentifier Id { get; }
        /// <summary> It must match the last segment of the id field, and will typically be a GUID / system generated value. </summary>
        public string Name { get; }
        /// <summary> Status of the operation. </summary>
        public CalculateExchangeOperationResultStatus? Status { get; }
        /// <summary> CalculateExchange response properties. </summary>
        public CalculateExchangeResultProperties Properties { get; }
        /// <summary> Required if status == failed or status == canceled. </summary>
        public OperationResultError Error { get; }
    }
}
