// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Reservations.Models
{
    /// <summary> Status of the operation. </summary>
    public readonly partial struct CalculateExchangeOperationResultStatus : IEquatable<CalculateExchangeOperationResultStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CalculateExchangeOperationResultStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CalculateExchangeOperationResultStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CancelledValue = "Cancelled";
        private const string PendingValue = "Pending";

        /// <summary> Succeeded. </summary>
        public static CalculateExchangeOperationResultStatus Succeeded { get; } = new CalculateExchangeOperationResultStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static CalculateExchangeOperationResultStatus Failed { get; } = new CalculateExchangeOperationResultStatus(FailedValue);
        /// <summary> Cancelled. </summary>
        public static CalculateExchangeOperationResultStatus Cancelled { get; } = new CalculateExchangeOperationResultStatus(CancelledValue);
        /// <summary> Pending. </summary>
        public static CalculateExchangeOperationResultStatus Pending { get; } = new CalculateExchangeOperationResultStatus(PendingValue);
        /// <summary> Determines if two <see cref="CalculateExchangeOperationResultStatus"/> values are the same. </summary>
        public static bool operator ==(CalculateExchangeOperationResultStatus left, CalculateExchangeOperationResultStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CalculateExchangeOperationResultStatus"/> values are not the same. </summary>
        public static bool operator !=(CalculateExchangeOperationResultStatus left, CalculateExchangeOperationResultStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CalculateExchangeOperationResultStatus"/>. </summary>
        public static implicit operator CalculateExchangeOperationResultStatus(string value) => new CalculateExchangeOperationResultStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CalculateExchangeOperationResultStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CalculateExchangeOperationResultStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
