// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Reservations.Models
{
    /// <summary> Calculate exchange request properties. </summary>
    public partial class CalculateExchangeContentProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CalculateExchangeContentProperties"/>. </summary>
        public CalculateExchangeContentProperties()
        {
            ReservationsToPurchase = new ChangeTrackingList<ReservationPurchaseContent>();
            SavingsPlansToPurchase = new ChangeTrackingList<SavingsPlanPurchase>();
            ReservationsToExchange = new ChangeTrackingList<ReservationToReturn>();
        }

        /// <summary> Initializes a new instance of <see cref="CalculateExchangeContentProperties"/>. </summary>
        /// <param name="reservationsToPurchase"> List of reservations that are being purchased in this exchange. </param>
        /// <param name="savingsPlansToPurchase"> List of savings plans that are being purchased in this exchange. </param>
        /// <param name="reservationsToExchange"> List of reservations that are being returned in this exchange. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CalculateExchangeContentProperties(IList<ReservationPurchaseContent> reservationsToPurchase, IList<SavingsPlanPurchase> savingsPlansToPurchase, IList<ReservationToReturn> reservationsToExchange, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ReservationsToPurchase = reservationsToPurchase;
            SavingsPlansToPurchase = savingsPlansToPurchase;
            ReservationsToExchange = reservationsToExchange;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of reservations that are being purchased in this exchange. </summary>
        public IList<ReservationPurchaseContent> ReservationsToPurchase { get; }
        /// <summary> List of savings plans that are being purchased in this exchange. </summary>
        public IList<SavingsPlanPurchase> SavingsPlansToPurchase { get; }
        /// <summary> List of reservations that are being returned in this exchange. </summary>
        public IList<ReservationToReturn> ReservationsToExchange { get; }
    }
}
