// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Reservations.Models
{
    /// <summary> Commitment grain. </summary>
    public readonly partial struct BenefitsCommitmentGrain : IEquatable<BenefitsCommitmentGrain>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BenefitsCommitmentGrain"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BenefitsCommitmentGrain(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HourlyValue = "Hourly";

        /// <summary> Hourly. </summary>
        public static BenefitsCommitmentGrain Hourly { get; } = new BenefitsCommitmentGrain(HourlyValue);
        /// <summary> Determines if two <see cref="BenefitsCommitmentGrain"/> values are the same. </summary>
        public static bool operator ==(BenefitsCommitmentGrain left, BenefitsCommitmentGrain right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BenefitsCommitmentGrain"/> values are not the same. </summary>
        public static bool operator !=(BenefitsCommitmentGrain left, BenefitsCommitmentGrain right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BenefitsCommitmentGrain"/>. </summary>
        public static implicit operator BenefitsCommitmentGrain(string value) => new BenefitsCommitmentGrain(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BenefitsCommitmentGrain other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BenefitsCommitmentGrain other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
