// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Reservations.Models
{
    /// <summary> Type of the Applied Scope. </summary>
    public readonly partial struct AppliedScopeType : IEquatable<AppliedScopeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AppliedScopeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AppliedScopeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SingleValue = "Single";
        private const string SharedValue = "Shared";
        private const string ManagementGroupValue = "ManagementGroup";

        /// <summary> Single. </summary>
        public static AppliedScopeType Single { get; } = new AppliedScopeType(SingleValue);
        /// <summary> Shared. </summary>
        public static AppliedScopeType Shared { get; } = new AppliedScopeType(SharedValue);
        /// <summary> ManagementGroup. </summary>
        public static AppliedScopeType ManagementGroup { get; } = new AppliedScopeType(ManagementGroupValue);
        /// <summary> Determines if two <see cref="AppliedScopeType"/> values are the same. </summary>
        public static bool operator ==(AppliedScopeType left, AppliedScopeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AppliedScopeType"/> values are not the same. </summary>
        public static bool operator !=(AppliedScopeType left, AppliedScopeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AppliedScopeType"/>. </summary>
        public static implicit operator AppliedScopeType(string value) => new AppliedScopeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AppliedScopeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AppliedScopeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
