// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Reservations
{
    internal class ReservationQuotaOperationSource : IOperationSource<ReservationQuotaResource>
    {
        private readonly ArmClient _client;

        internal ReservationQuotaOperationSource(ArmClient client)
        {
            _client = client;
        }

        ReservationQuotaResource IOperationSource<ReservationQuotaResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ReservationQuotaData.DeserializeReservationQuotaData(document.RootElement);
            return new ReservationQuotaResource(_client, data);
        }

        async ValueTask<ReservationQuotaResource> IOperationSource<ReservationQuotaResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ReservationQuotaData.DeserializeReservationQuotaData(document.RootElement);
            return new ReservationQuotaResource(_client, data);
        }
    }
}
