// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Reservations
{
    internal class ReservationDetailOperationSource : IOperationSource<ReservationDetailResource>
    {
        private readonly ArmClient _client;

        internal ReservationDetailOperationSource(ArmClient client)
        {
            _client = client;
        }

        ReservationDetailResource IOperationSource<ReservationDetailResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = ReservationDetailData.DeserializeReservationDetailData(document.RootElement);
            return new ReservationDetailResource(_client, data);
        }

        async ValueTask<ReservationDetailResource> IOperationSource<ReservationDetailResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = ReservationDetailData.DeserializeReservationDetailData(document.RootElement);
            return new ReservationDetailResource(_client, data);
        }
    }
}
