// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.Reservations.Models;

namespace Azure.ResourceManager.Reservations
{
    internal class ExchangeResultOperationSource : IOperationSource<ExchangeResult>
    {
        ExchangeResult IOperationSource<ExchangeResult>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return ExchangeResult.DeserializeExchangeResult(document.RootElement);
        }

        async ValueTask<ExchangeResult> IOperationSource<ExchangeResult>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return ExchangeResult.DeserializeExchangeResult(document.RootElement);
        }
    }
}
