// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Reservations.Models;

namespace Azure.ResourceManager.Reservations.Samples
{
    public partial class Sample_TenantResourceExtensions
    {
        // CalculateExchange
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CalculateReservationExchange_CalculateExchange()
        {
            // Generated from example definition: specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/CalculateExchange.json
            // this example is just showing the usage of "CalculateExchange_Post" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            CalculateExchangeContent content = new CalculateExchangeContent()
            {
                Properties = new CalculateExchangeContentProperties()
                {
                    ReservationsToPurchase =
{
new ReservationPurchaseContent()
{
SkuName = "Standard_B1ls",
Location = new AzureLocation("westus"),
ReservedResourceType = ReservedResourceType.VirtualMachines,
BillingScopeId = new ResourceIdentifier("/subscriptions/ed3a1871-612d-abcd-a849-c2542a68be83"),
Term = ReservationTerm.P1Y,
BillingPlan = ReservationBillingPlan.Upfront,
Quantity = 1,
DisplayName = "testDisplayName",
AppliedScopeType = AppliedScopeType.Shared,
AppliedScopes =
{
},
IsRenewEnabled = false,
ReservedResourceInstanceFlexibility = InstanceFlexibility.On,
}
},
                    SavingsPlansToPurchase =
{
new SavingsPlanPurchase()
{
SkuName = "Compute_Savings_Plan",
DisplayName = "ComputeSavingsPlan",
BillingScopeId = new ResourceIdentifier("/subscriptions/10000000-0000-0000-0000-000000000000"),
Term = SavingsPlanTerm.P1Y,
AppliedScopeType = AppliedScopeType.Single,
AppliedScopeProperties = new AppliedScopeProperties()
{
ResourceGroupId = new ResourceIdentifier("/subscriptions/10000000-0000-0000-0000-000000000000/resourceGroups/testrg"),
},
Commitment = new BenefitsCommitment()
{
Grain = BenefitsCommitmentGrain.Hourly,
CurrencyCode = "USD",
Amount = 15.23,
},
}
},
                    ReservationsToExchange =
{
new ReservationToReturn()
{
ReservationId = new ResourceIdentifier("/providers/microsoft.capacity/reservationOrders/1f14354c-dc12-4c8d-8090-6f295a3a34aa/reservations/c8c926bd-fc5d-4e29-9d43-b68340ac23a6"),
Quantity = 1,
}
},
                },
            };
            ArmOperation<CalculateExchangeResult> lro = await tenantResource.CalculateReservationExchangeAsync(WaitUntil.Completed, content);
            CalculateExchangeResult result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // Exchange
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exchange_Exchange()
        {
            // Generated from example definition: specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/Exchange.json
            // this example is just showing the usage of "Exchange_Post" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            ExchangeContent content = new ExchangeContent()
            {
                ExchangeRequestSessionId = Guid.Parse("66e2ac8f-439e-4345-8235-6fef07608081"),
            };
            ArmOperation<ExchangeResult> lro = await tenantResource.ExchangeAsync(WaitUntil.Completed, content);
            ExchangeResult result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
