// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Reservations.Models;

namespace Azure.ResourceManager.Reservations.Samples
{
    public partial class Sample_ReservationQuotaResource
    {
        // Quotas_Request_ForCompute
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_QuotasRequestForCompute()
        {
            // Generated from example definition: specification/reservations/resource-manager/Microsoft.Capacity/stable/2020-10-25/examples/getComputeOneSkuUsages.json
            // this example is just showing the usage of "Quota_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReservationQuotaResource created on azure
            // for more information of creating ReservationQuotaResource, please refer to the document of ReservationQuotaResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string providerId = "Microsoft.Compute";
            AzureLocation location = new AzureLocation("eastus");
            string resourceName = "standardNDSFamily";
            ResourceIdentifier reservationQuotaResourceId = ReservationQuotaResource.CreateResourceIdentifier(subscriptionId, providerId, location, resourceName);
            ReservationQuotaResource reservationQuota = client.GetReservationQuotaResource(reservationQuotaResourceId);

            // invoke the operation
            ReservationQuotaResource result = await reservationQuota.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReservationQuotaData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Quotas_Request_PatchForCompute
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_QuotasRequestPatchForCompute()
        {
            // Generated from example definition: specification/reservations/resource-manager/Microsoft.Capacity/stable/2020-10-25/examples/patchComputeQuotaRequest.json
            // this example is just showing the usage of "Quota_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReservationQuotaResource created on azure
            // for more information of creating ReservationQuotaResource, please refer to the document of ReservationQuotaResource
            string subscriptionId = "D7EC67B3-7657-4966-BFFC-41EFD36BAAB3";
            string providerId = "Microsoft.Compute";
            AzureLocation location = new AzureLocation("eastus");
            string resourceName = "standardFSv2Family";
            ResourceIdentifier reservationQuotaResourceId = ReservationQuotaResource.CreateResourceIdentifier(subscriptionId, providerId, location, resourceName);
            ReservationQuotaResource reservationQuota = client.GetReservationQuotaResource(reservationQuotaResourceId);

            // invoke the operation
            ReservationQuotaData data = new ReservationQuotaData()
            {
                Properties = new QuotaProperties()
                {
                    Limit = 200,
                    Unit = "Count",
                    ResourceName = new ReservationResourceName()
                    {
                        Value = "standardFSv2Family",
                    },
                },
            };
            ArmOperation<ReservationQuotaResource> lro = await reservationQuota.UpdateAsync(WaitUntil.Completed, data);
            ReservationQuotaResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReservationQuotaData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
