// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Reservations.Models;

namespace Azure.ResourceManager.Reservations.Samples
{
    public partial class Sample_ReservationDetailResource
    {
        // AvailableScopes
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAvailableScopes_AvailableScopes()
        {
            // Generated from example definition: specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/GetAvailableScope.json
            // this example is just showing the usage of "Reservation_AvailableScopes" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReservationDetailResource created on azure
            // for more information of creating ReservationDetailResource, please refer to the document of ReservationDetailResource
            Guid reservationOrderId = Guid.Parse("276e7ae4-84d0-4da6-ab4b-d6b94f3557da");
            Guid reservationId = Guid.Parse("356e7ae4-84d0-4da6-ab4b-d6b94f3557da");
            ResourceIdentifier reservationDetailResourceId = ReservationDetailResource.CreateResourceIdentifier(reservationOrderId, reservationId);
            ReservationDetailResource reservationDetail = client.GetReservationDetailResource(reservationDetailResourceId);

            // invoke the operation
            AvailableScopesContent content = new AvailableScopesContent()
            {
                Scopes =
{
"/subscriptions/efc7c997-7700-4a74-b731-55aec16c15e9"
},
            };
            ArmOperation<AvailableScopesProperties> lro = await reservationDetail.GetAvailableScopesAsync(WaitUntil.Completed, content);
            AvailableScopesProperties result = lro.Value;

            Console.WriteLine($"Succeeded: {result}");
        }

        // GetReservation
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetReservation()
        {
            // Generated from example definition: specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/GetReservationDetails.json
            // this example is just showing the usage of "Reservation_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReservationDetailResource created on azure
            // for more information of creating ReservationDetailResource, please refer to the document of ReservationDetailResource
            Guid reservationOrderId = Guid.Parse("276e7ae4-84d0-4da6-ab4b-d6b94f3557da");
            Guid reservationId = Guid.Parse("6ef59113-3482-40da-8d79-787f823e34bc");
            ResourceIdentifier reservationDetailResourceId = ReservationDetailResource.CreateResourceIdentifier(reservationOrderId, reservationId);
            ReservationDetailResource reservationDetail = client.GetReservationDetailResource(reservationDetailResourceId);

            // invoke the operation
            string expand = "renewProperties";
            ReservationDetailResource result = await reservationDetail.GetAsync(expand: expand);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReservationDetailData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // PatchReservation
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_PatchReservation()
        {
            // Generated from example definition: specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/UpdateReservation.json
            // this example is just showing the usage of "Reservation_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReservationDetailResource created on azure
            // for more information of creating ReservationDetailResource, please refer to the document of ReservationDetailResource
            Guid reservationOrderId = Guid.Parse("276e7ae4-84d0-4da6-ab4b-d6b94f3557da");
            Guid reservationId = Guid.Parse("6ef59113-3482-40da-8d79-787f823e34bc");
            ResourceIdentifier reservationDetailResourceId = ReservationDetailResource.CreateResourceIdentifier(reservationOrderId, reservationId);
            ReservationDetailResource reservationDetail = client.GetReservationDetailResource(reservationDetailResourceId);

            // invoke the operation
            ReservationDetailPatch patch = new ReservationDetailPatch()
            {
                AppliedScopeType = AppliedScopeType.Shared,
                InstanceFlexibility = InstanceFlexibility.Off,
            };
            ArmOperation<ReservationDetailResource> lro = await reservationDetail.UpdateAsync(WaitUntil.Completed, patch);
            ReservationDetailResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReservationDetailData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Archive
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Archive_Archive()
        {
            // Generated from example definition: specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/Archive.json
            // this example is just showing the usage of "Reservation_Archive" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReservationDetailResource created on azure
            // for more information of creating ReservationDetailResource, please refer to the document of ReservationDetailResource
            Guid reservationOrderId = Guid.Parse("276e7ae4-84d0-4da6-ab4b-d6b94f3557da");
            Guid reservationId = Guid.Parse("356e7ae4-84d0-4da6-ab4b-d6b94f3557da");
            ResourceIdentifier reservationDetailResourceId = ReservationDetailResource.CreateResourceIdentifier(reservationOrderId, reservationId);
            ReservationDetailResource reservationDetail = client.GetReservationDetailResource(reservationDetailResourceId);

            // invoke the operation
            await reservationDetail.ArchiveAsync();

            Console.WriteLine($"Succeeded");
        }

        // Unarchive
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Unarchive_Unarchive()
        {
            // Generated from example definition: specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/Unarchive.json
            // this example is just showing the usage of "Reservation_Unarchive" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReservationDetailResource created on azure
            // for more information of creating ReservationDetailResource, please refer to the document of ReservationDetailResource
            Guid reservationOrderId = Guid.Parse("276e7ae4-84d0-4da6-ab4b-d6b94f3557da");
            Guid reservationId = Guid.Parse("356e7ae4-84d0-4da6-ab4b-d6b94f3557da");
            ResourceIdentifier reservationDetailResourceId = ReservationDetailResource.CreateResourceIdentifier(reservationOrderId, reservationId);
            ReservationDetailResource reservationDetail = client.GetReservationDetailResource(reservationDetailResourceId);

            // invoke the operation
            await reservationDetail.UnarchiveAsync();

            Console.WriteLine($"Succeeded");
        }

        // ReservationListAll
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetReservationDetails_ReservationListAll()
        {
            // Generated from example definition: specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/GetReservations.json
            // this example is just showing the usage of "Reservation_ListAll" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation and iterate over the result
            TenantResourceGetReservationDetailsOptions options = new TenantResourceGetReservationDetailsOptions() { Filter = "(properties%2farchived+eq+false)", Orderby = "properties/displayName asc", Skiptoken = 50, Take = 1 };
            await foreach (ReservationDetailResource item in tenantResource.GetReservationDetailsAsync(options))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ReservationDetailData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
