// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Reservations.Samples
{
    public partial class Sample_ReservationDetailCollection
    {
        // ReservationList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ReservationList()
        {
            // Generated from example definition: specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/GetReservationsFromOrder.json
            // this example is just showing the usage of "Reservation_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReservationOrderResource created on azure
            // for more information of creating ReservationOrderResource, please refer to the document of ReservationOrderResource
            Guid reservationOrderId = Guid.Parse("276e7ae4-84d0-4da6-ab4b-d6b94f3557da");
            ResourceIdentifier reservationOrderResourceId = ReservationOrderResource.CreateResourceIdentifier(reservationOrderId);
            ReservationOrderResource reservationOrder = client.GetReservationOrderResource(reservationOrderResourceId);

            // get the collection of this ReservationDetailResource
            ReservationDetailCollection collection = reservationOrder.GetReservationDetails();

            // invoke the operation and iterate over the result
            await foreach (ReservationDetailResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ReservationDetailData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // GetReservation
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetReservation()
        {
            // Generated from example definition: specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/GetReservationDetails.json
            // this example is just showing the usage of "Reservation_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReservationOrderResource created on azure
            // for more information of creating ReservationOrderResource, please refer to the document of ReservationOrderResource
            Guid reservationOrderId = Guid.Parse("276e7ae4-84d0-4da6-ab4b-d6b94f3557da");
            ResourceIdentifier reservationOrderResourceId = ReservationOrderResource.CreateResourceIdentifier(reservationOrderId);
            ReservationOrderResource reservationOrder = client.GetReservationOrderResource(reservationOrderResourceId);

            // get the collection of this ReservationDetailResource
            ReservationDetailCollection collection = reservationOrder.GetReservationDetails();

            // invoke the operation
            Guid reservationId = Guid.Parse("6ef59113-3482-40da-8d79-787f823e34bc");
            string expand = "renewProperties";
            ReservationDetailResource result = await collection.GetAsync(reservationId, expand: expand);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ReservationDetailData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // GetReservation
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetReservation()
        {
            // Generated from example definition: specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/GetReservationDetails.json
            // this example is just showing the usage of "Reservation_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReservationOrderResource created on azure
            // for more information of creating ReservationOrderResource, please refer to the document of ReservationOrderResource
            Guid reservationOrderId = Guid.Parse("276e7ae4-84d0-4da6-ab4b-d6b94f3557da");
            ResourceIdentifier reservationOrderResourceId = ReservationOrderResource.CreateResourceIdentifier(reservationOrderId);
            ReservationOrderResource reservationOrder = client.GetReservationOrderResource(reservationOrderResourceId);

            // get the collection of this ReservationDetailResource
            ReservationDetailCollection collection = reservationOrder.GetReservationDetails();

            // invoke the operation
            Guid reservationId = Guid.Parse("6ef59113-3482-40da-8d79-787f823e34bc");
            string expand = "renewProperties";
            bool result = await collection.ExistsAsync(reservationId, expand: expand);

            Console.WriteLine($"Succeeded: {result}");
        }

        // GetReservation
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetReservation()
        {
            // Generated from example definition: specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/GetReservationDetails.json
            // this example is just showing the usage of "Reservation_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReservationOrderResource created on azure
            // for more information of creating ReservationOrderResource, please refer to the document of ReservationOrderResource
            Guid reservationOrderId = Guid.Parse("276e7ae4-84d0-4da6-ab4b-d6b94f3557da");
            ResourceIdentifier reservationOrderResourceId = ReservationOrderResource.CreateResourceIdentifier(reservationOrderId);
            ReservationOrderResource reservationOrder = client.GetReservationOrderResource(reservationOrderResourceId);

            // get the collection of this ReservationDetailResource
            ReservationDetailCollection collection = reservationOrder.GetReservationDetails();

            // invoke the operation
            Guid reservationId = Guid.Parse("6ef59113-3482-40da-8d79-787f823e34bc");
            string expand = "renewProperties";
            NullableResponse<ReservationDetailResource> response = await collection.GetIfExistsAsync(reservationId, expand: expand);
            ReservationDetailResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ReservationDetailData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // ReservationRevisions
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetRevisions_ReservationRevisions()
        {
            // Generated from example definition: specification/reservations/resource-manager/Microsoft.Capacity/stable/2022-11-01/examples/GetReservationRevisions.json
            // this example is just showing the usage of "Reservation_ListRevisions" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ReservationOrderResource created on azure
            // for more information of creating ReservationOrderResource, please refer to the document of ReservationOrderResource
            Guid reservationOrderId = Guid.Parse("276e7ae4-84d0-4da6-ab4b-d6b94f3557da");
            ResourceIdentifier reservationOrderResourceId = ReservationOrderResource.CreateResourceIdentifier(reservationOrderId);
            ReservationOrderResource reservationOrder = client.GetReservationOrderResource(reservationOrderResourceId);

            // get the collection of this ReservationDetailResource
            ReservationDetailCollection collection = reservationOrder.GetReservationDetails();

            // invoke the operation and iterate over the result
            Guid reservationId = Guid.Parse("6ef59113-3482-40da-8d79-787f823e34bc");
            await foreach (ReservationDetailResource item in collection.GetRevisionsAsync(reservationId))
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ReservationDetailData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
