// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Reservations.Samples
{
    public partial class Sample_QuotaRequestDetailResource
    {
        // QuotaRequestFailed
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_QuotaRequestFailed()
        {
            // Generated from example definition: specification/reservations/resource-manager/Microsoft.Capacity/stable/2020-10-25/examples/getQuotaRequestStatusFailed.json
            // this example is just showing the usage of "QuotaRequestStatus_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this QuotaRequestDetailResource created on azure
            // for more information of creating QuotaRequestDetailResource, please refer to the document of QuotaRequestDetailResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string providerId = "Microsoft.Compute";
            AzureLocation location = new AzureLocation("eastus");
            Guid id = Guid.Parse("2B5C8515-37D8-4B6A-879B-CD641A2CF605");
            ResourceIdentifier quotaRequestDetailResourceId = QuotaRequestDetailResource.CreateResourceIdentifier(subscriptionId, providerId, location, id);
            QuotaRequestDetailResource quotaRequestDetail = client.GetQuotaRequestDetailResource(quotaRequestDetailResourceId);

            // invoke the operation
            QuotaRequestDetailResource result = await quotaRequestDetail.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            QuotaRequestDetailData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // QuotaRequestInProgress
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_QuotaRequestInProgress()
        {
            // Generated from example definition: specification/reservations/resource-manager/Microsoft.Capacity/stable/2020-10-25/examples/getQuotaRequestStatusInProgress.json
            // this example is just showing the usage of "QuotaRequestStatus_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this QuotaRequestDetailResource created on azure
            // for more information of creating QuotaRequestDetailResource, please refer to the document of QuotaRequestDetailResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string providerId = "Microsoft.Compute";
            AzureLocation location = new AzureLocation("eastus");
            Guid id = Guid.Parse("2B5C8515-37D8-4B6A-879B-CD641A2CF605");
            ResourceIdentifier quotaRequestDetailResourceId = QuotaRequestDetailResource.CreateResourceIdentifier(subscriptionId, providerId, location, id);
            QuotaRequestDetailResource quotaRequestDetail = client.GetQuotaRequestDetailResource(quotaRequestDetailResourceId);

            // invoke the operation
            QuotaRequestDetailResource result = await quotaRequestDetail.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            QuotaRequestDetailData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // QuotaRequestStatus
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_QuotaRequestStatus()
        {
            // Generated from example definition: specification/reservations/resource-manager/Microsoft.Capacity/stable/2020-10-25/examples/getQuotaRequestStatusById.json
            // this example is just showing the usage of "QuotaRequestStatus_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this QuotaRequestDetailResource created on azure
            // for more information of creating QuotaRequestDetailResource, please refer to the document of QuotaRequestDetailResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string providerId = "Microsoft.Compute";
            AzureLocation location = new AzureLocation("eastus");
            Guid id = Guid.Parse("2B5C8515-37D8-4B6A-879B-CD641A2CF605");
            ResourceIdentifier quotaRequestDetailResourceId = QuotaRequestDetailResource.CreateResourceIdentifier(subscriptionId, providerId, location, id);
            QuotaRequestDetailResource quotaRequestDetail = client.GetQuotaRequestDetailResource(quotaRequestDetailResourceId);

            // invoke the operation
            QuotaRequestDetailResource result = await quotaRequestDetail.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            QuotaRequestDetailData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
