// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.MixedReality.RemoteRendering
{
    internal partial class RemoteRenderingRestClient
    {
        private readonly HttpPipeline _pipeline;
        private readonly string _endpoint;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> Initializes a new instance of RemoteRenderingRestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> The endpoint to use e.g. https://remoterendering.eastus.mixedreality.azure.com. A list can be found at https://docs.microsoft.com/azure/remote-rendering/reference/regions. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/>, <paramref name="endpoint"/> or <paramref name="apiVersion"/> is null. </exception>
        public RemoteRenderingRestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, string endpoint, string apiVersion = "2021-01-01")
        {
            ClientDiagnostics = clientDiagnostics ?? throw new ArgumentNullException(nameof(clientDiagnostics));
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? throw new ArgumentNullException(nameof(endpoint));
            _apiVersion = apiVersion ?? throw new ArgumentNullException(nameof(apiVersion));
        }

        internal HttpMessage CreateCreateConversionRequest(Guid accountId, string conversionId, CreateConversionSettings body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendPath("/accounts/", false);
            uri.AppendPath(accountId, true);
            uri.AppendPath("/conversions/", false);
            uri.AppendPath(conversionId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Creates a conversion using an asset stored in an Azure Blob Storage account. </summary>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="conversionId"> An ID uniquely identifying the conversion for the given account. The ID is case sensitive, can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 256 characters. </param>
        /// <param name="body"> Request body configuring the settings for an asset conversion. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="conversionId"/> or <paramref name="body"/> is null. </exception>
        public async Task<ResponseWithHeaders<AssetConversion, RemoteRenderingCreateConversionHeaders>> CreateConversionAsync(Guid accountId, string conversionId, CreateConversionSettings body, CancellationToken cancellationToken = default)
        {
            if (conversionId == null)
            {
                throw new ArgumentNullException(nameof(conversionId));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateCreateConversionRequest(accountId, conversionId, body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new RemoteRenderingCreateConversionHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    {
                        AssetConversion value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AssetConversion.DeserializeAssetConversion(document.RootElement);
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Creates a conversion using an asset stored in an Azure Blob Storage account. </summary>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="conversionId"> An ID uniquely identifying the conversion for the given account. The ID is case sensitive, can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 256 characters. </param>
        /// <param name="body"> Request body configuring the settings for an asset conversion. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="conversionId"/> or <paramref name="body"/> is null. </exception>
        public ResponseWithHeaders<AssetConversion, RemoteRenderingCreateConversionHeaders> CreateConversion(Guid accountId, string conversionId, CreateConversionSettings body, CancellationToken cancellationToken = default)
        {
            if (conversionId == null)
            {
                throw new ArgumentNullException(nameof(conversionId));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateCreateConversionRequest(accountId, conversionId, body);
            _pipeline.Send(message, cancellationToken);
            var headers = new RemoteRenderingCreateConversionHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    {
                        AssetConversion value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AssetConversion.DeserializeAssetConversion(document.RootElement);
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetConversionRequest(Guid accountId, string conversionId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendPath("/accounts/", false);
            uri.AppendPath(accountId, true);
            uri.AppendPath("/conversions/", false);
            uri.AppendPath(conversionId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Gets the status of a particular conversion. </summary>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="conversionId"> An ID uniquely identifying the conversion for the given account. The ID is case sensitive, can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 256 characters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="conversionId"/> is null. </exception>
        public async Task<ResponseWithHeaders<AssetConversion, RemoteRenderingGetConversionHeaders>> GetConversionAsync(Guid accountId, string conversionId, CancellationToken cancellationToken = default)
        {
            if (conversionId == null)
            {
                throw new ArgumentNullException(nameof(conversionId));
            }

            using var message = CreateGetConversionRequest(accountId, conversionId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new RemoteRenderingGetConversionHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AssetConversion value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = AssetConversion.DeserializeAssetConversion(document.RootElement);
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets the status of a particular conversion. </summary>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="conversionId"> An ID uniquely identifying the conversion for the given account. The ID is case sensitive, can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 256 characters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="conversionId"/> is null. </exception>
        public ResponseWithHeaders<AssetConversion, RemoteRenderingGetConversionHeaders> GetConversion(Guid accountId, string conversionId, CancellationToken cancellationToken = default)
        {
            if (conversionId == null)
            {
                throw new ArgumentNullException(nameof(conversionId));
            }

            using var message = CreateGetConversionRequest(accountId, conversionId);
            _pipeline.Send(message, cancellationToken);
            var headers = new RemoteRenderingGetConversionHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        AssetConversion value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = AssetConversion.DeserializeAssetConversion(document.RootElement);
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListConversionsRequest(Guid accountId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendPath("/accounts/", false);
            uri.AppendPath(accountId, true);
            uri.AppendPath("/conversions", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Gets a list of all conversions. </summary>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<ResponseWithHeaders<ConversionList, RemoteRenderingListConversionsHeaders>> ListConversionsAsync(Guid accountId, CancellationToken cancellationToken = default)
        {
            using var message = CreateListConversionsRequest(accountId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new RemoteRenderingListConversionsHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ConversionList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = ConversionList.DeserializeConversionList(document.RootElement);
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets a list of all conversions. </summary>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public ResponseWithHeaders<ConversionList, RemoteRenderingListConversionsHeaders> ListConversions(Guid accountId, CancellationToken cancellationToken = default)
        {
            using var message = CreateListConversionsRequest(accountId);
            _pipeline.Send(message, cancellationToken);
            var headers = new RemoteRenderingListConversionsHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ConversionList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = ConversionList.DeserializeConversionList(document.RootElement);
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateCreateSessionRequest(Guid accountId, string sessionId, RenderingSessionOptions body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendPath("/accounts/", false);
            uri.AppendPath(accountId, true);
            uri.AppendPath("/sessions/", false);
            uri.AppendPath(sessionId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Creates a new rendering session. </summary>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="sessionId"> An ID uniquely identifying the rendering session for the given account. The ID is case sensitive, can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 256 characters. </param>
        /// <param name="body"> Settings of the session to be created. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> or <paramref name="body"/> is null. </exception>
        public async Task<ResponseWithHeaders<RenderingSession, RemoteRenderingCreateSessionHeaders>> CreateSessionAsync(Guid accountId, string sessionId, RenderingSessionOptions body, CancellationToken cancellationToken = default)
        {
            if (sessionId == null)
            {
                throw new ArgumentNullException(nameof(sessionId));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateCreateSessionRequest(accountId, sessionId, body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new RemoteRenderingCreateSessionHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    {
                        RenderingSession value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = RenderingSession.DeserializeRenderingSession(document.RootElement);
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Creates a new rendering session. </summary>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="sessionId"> An ID uniquely identifying the rendering session for the given account. The ID is case sensitive, can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 256 characters. </param>
        /// <param name="body"> Settings of the session to be created. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> or <paramref name="body"/> is null. </exception>
        public ResponseWithHeaders<RenderingSession, RemoteRenderingCreateSessionHeaders> CreateSession(Guid accountId, string sessionId, RenderingSessionOptions body, CancellationToken cancellationToken = default)
        {
            if (sessionId == null)
            {
                throw new ArgumentNullException(nameof(sessionId));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateCreateSessionRequest(accountId, sessionId, body);
            _pipeline.Send(message, cancellationToken);
            var headers = new RemoteRenderingCreateSessionHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                case 201:
                    {
                        RenderingSession value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = RenderingSession.DeserializeRenderingSession(document.RootElement);
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetSessionRequest(Guid accountId, string sessionId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendPath("/accounts/", false);
            uri.AppendPath(accountId, true);
            uri.AppendPath("/sessions/", false);
            uri.AppendPath(sessionId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Gets the properties of a particular rendering session. </summary>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="sessionId"> An ID uniquely identifying the rendering session for the given account. The ID is case sensitive, can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 256 characters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        public async Task<Response<RenderingSession>> GetSessionAsync(Guid accountId, string sessionId, CancellationToken cancellationToken = default)
        {
            if (sessionId == null)
            {
                throw new ArgumentNullException(nameof(sessionId));
            }

            using var message = CreateGetSessionRequest(accountId, sessionId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RenderingSession value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = RenderingSession.DeserializeRenderingSession(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets the properties of a particular rendering session. </summary>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="sessionId"> An ID uniquely identifying the rendering session for the given account. The ID is case sensitive, can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 256 characters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        public Response<RenderingSession> GetSession(Guid accountId, string sessionId, CancellationToken cancellationToken = default)
        {
            if (sessionId == null)
            {
                throw new ArgumentNullException(nameof(sessionId));
            }

            using var message = CreateGetSessionRequest(accountId, sessionId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RenderingSession value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = RenderingSession.DeserializeRenderingSession(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateUpdateSessionRequest(Guid accountId, string sessionId, UpdateSessionOptions body)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendPath("/accounts/", false);
            uri.AppendPath(accountId, true);
            uri.AppendPath("/sessions/", false);
            uri.AppendPath(sessionId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(body);
            request.Content = content;
            return message;
        }

        /// <summary> Updates the max lease time of a particular rendering session. </summary>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="sessionId"> An ID uniquely identifying the rendering session for the given account. The ID is case sensitive, can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 256 characters. </param>
        /// <param name="body"> Settings used to update the session. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> or <paramref name="body"/> is null. </exception>
        public async Task<Response<RenderingSession>> UpdateSessionAsync(Guid accountId, string sessionId, UpdateSessionOptions body, CancellationToken cancellationToken = default)
        {
            if (sessionId == null)
            {
                throw new ArgumentNullException(nameof(sessionId));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateUpdateSessionRequest(accountId, sessionId, body);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RenderingSession value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = RenderingSession.DeserializeRenderingSession(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Updates the max lease time of a particular rendering session. </summary>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="sessionId"> An ID uniquely identifying the rendering session for the given account. The ID is case sensitive, can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 256 characters. </param>
        /// <param name="body"> Settings used to update the session. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> or <paramref name="body"/> is null. </exception>
        public Response<RenderingSession> UpdateSession(Guid accountId, string sessionId, UpdateSessionOptions body, CancellationToken cancellationToken = default)
        {
            if (sessionId == null)
            {
                throw new ArgumentNullException(nameof(sessionId));
            }
            if (body == null)
            {
                throw new ArgumentNullException(nameof(body));
            }

            using var message = CreateUpdateSessionRequest(accountId, sessionId, body);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        RenderingSession value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = RenderingSession.DeserializeRenderingSession(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateStopSessionRequest(Guid accountId, string sessionId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendPath("/accounts/", false);
            uri.AppendPath(accountId, true);
            uri.AppendPath("/sessions/", false);
            uri.AppendPath(sessionId, true);
            uri.AppendPath("/:stop", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Stops a particular rendering session. </summary>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="sessionId"> An ID uniquely identifying the rendering session for the given account. The ID is case sensitive, can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 256 characters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        public async Task<ResponseWithHeaders<RemoteRenderingStopSessionHeaders>> StopSessionAsync(Guid accountId, string sessionId, CancellationToken cancellationToken = default)
        {
            if (sessionId == null)
            {
                throw new ArgumentNullException(nameof(sessionId));
            }

            using var message = CreateStopSessionRequest(accountId, sessionId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new RemoteRenderingStopSessionHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 204:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Stops a particular rendering session. </summary>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="sessionId"> An ID uniquely identifying the rendering session for the given account. The ID is case sensitive, can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 256 characters. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sessionId"/> is null. </exception>
        public ResponseWithHeaders<RemoteRenderingStopSessionHeaders> StopSession(Guid accountId, string sessionId, CancellationToken cancellationToken = default)
        {
            if (sessionId == null)
            {
                throw new ArgumentNullException(nameof(sessionId));
            }

            using var message = CreateStopSessionRequest(accountId, sessionId);
            _pipeline.Send(message, cancellationToken);
            var headers = new RemoteRenderingStopSessionHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 204:
                    return ResponseWithHeaders.FromValue(headers, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListSessionsRequest(Guid accountId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendPath("/accounts/", false);
            uri.AppendPath(accountId, true);
            uri.AppendPath("/sessions", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Gets a list of all rendering sessions. </summary>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<SessionsList>> ListSessionsAsync(Guid accountId, CancellationToken cancellationToken = default)
        {
            using var message = CreateListSessionsRequest(accountId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SessionsList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SessionsList.DeserializeSessionsList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets a list of all rendering sessions. </summary>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<SessionsList> ListSessions(Guid accountId, CancellationToken cancellationToken = default)
        {
            using var message = CreateListSessionsRequest(accountId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SessionsList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SessionsList.DeserializeSessionsList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListConversionsNextPageRequest(string nextLink, Guid accountId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Gets a list of all conversions. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public async Task<ResponseWithHeaders<ConversionList, RemoteRenderingListConversionsHeaders>> ListConversionsNextPageAsync(string nextLink, Guid accountId, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateListConversionsNextPageRequest(nextLink, accountId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            var headers = new RemoteRenderingListConversionsHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ConversionList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = ConversionList.DeserializeConversionList(document.RootElement);
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets a list of all conversions. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public ResponseWithHeaders<ConversionList, RemoteRenderingListConversionsHeaders> ListConversionsNextPage(string nextLink, Guid accountId, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateListConversionsNextPageRequest(nextLink, accountId);
            _pipeline.Send(message, cancellationToken);
            var headers = new RemoteRenderingListConversionsHeaders(message.Response);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ConversionList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = ConversionList.DeserializeConversionList(document.RootElement);
                        return ResponseWithHeaders.FromValue(value, headers, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateListSessionsNextPageRequest(string nextLink, Guid accountId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.AppendRaw(_endpoint, false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Gets a list of all rendering sessions. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public async Task<Response<SessionsList>> ListSessionsNextPageAsync(string nextLink, Guid accountId, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateListSessionsNextPageRequest(nextLink, accountId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SessionsList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SessionsList.DeserializeSessionsList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets a list of all rendering sessions. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="accountId"> The Azure Remote Rendering account ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public Response<SessionsList> ListSessionsNextPage(string nextLink, Guid accountId, CancellationToken cancellationToken = default)
        {
            if (nextLink == null)
            {
                throw new ArgumentNullException(nameof(nextLink));
            }

            using var message = CreateListSessionsNextPageRequest(nextLink, accountId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SessionsList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SessionsList.DeserializeSessionsList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
