// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;

namespace Azure.MixedReality.RemoteRendering
{
    public partial class RenderingSession
    {
        internal static RenderingSession DeserializeRenderingSession(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string id = default;
            int? arrInspectorPort = default;
            int? handshakePort = default;
            int? elapsedTimeMinutes = default;
            string hostname = default;
            int? maxLeaseTimeMinutes = default;
            RenderingServerSize size = default;
            RenderingSessionStatus status = default;
            float? teraflops = default;
            RemoteRenderingServiceError error = default;
            DateTimeOffset? creationTime = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("arrInspectorPort"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    arrInspectorPort = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("handshakePort"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    handshakePort = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("elapsedTimeMinutes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    elapsedTimeMinutes = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("hostname"u8))
                {
                    hostname = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("maxLeaseTimeMinutes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxLeaseTimeMinutes = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("size"u8))
                {
                    size = new RenderingServerSize(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("status"u8))
                {
                    status = new RenderingSessionStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("teraflops"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    teraflops = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("error"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        error = null;
                        continue;
                    }
                    error = RemoteRenderingServiceError.DeserializeRemoteRenderingServiceError(property.Value);
                    continue;
                }
                if (property.NameEquals("creationTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    creationTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
            }
            return new RenderingSession(
                id,
                arrInspectorPort,
                handshakePort,
                elapsedTimeMinutes,
                hostname,
                maxLeaseTimeMinutes,
                size,
                status,
                teraflops,
                error,
                creationTime);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static RenderingSession FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeRenderingSession(document.RootElement);
        }
    }
}
