// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.MixedReality.RemoteRendering
{
    /// <summary> List of conversions. </summary>
    internal partial class ConversionList
    {
        /// <summary> Initializes a new instance of <see cref="ConversionList"/>. </summary>
        /// <param name="conversions"> The list of conversions. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="conversions"/> is null. </exception>
        internal ConversionList(IEnumerable<AssetConversion> conversions)
        {
            Argument.AssertNotNull(conversions, nameof(conversions));

            Conversions = conversions.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="ConversionList"/>. </summary>
        /// <param name="conversions"> The list of conversions. </param>
        /// <param name="nextLink"> If more conversions are available this field will contain a URL where the next batch of conversions can be requested. This URL will need the same authentication as all calls to the Azure Remote Rendering API. </param>
        internal ConversionList(IReadOnlyList<AssetConversion> conversions, string nextLink)
        {
            Conversions = conversions;
            NextLink = nextLink;
        }

        /// <summary> The list of conversions. </summary>
        public IReadOnlyList<AssetConversion> Conversions { get; }
        /// <summary> If more conversions are available this field will contain a URL where the next batch of conversions can be requested. This URL will need the same authentication as all calls to the Azure Remote Rendering API. </summary>
        public string NextLink { get; }
    }
}
