// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using Azure.Core;

namespace Azure.MixedReality.RemoteRendering
{
    public partial class AssetConversionInputOptions : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("storageContainerUri"u8);
            writer.WriteStringValue(StorageContainerUri.AbsoluteUri);
            if (Optional.IsDefined(StorageContainerReadListSas))
            {
                writer.WritePropertyName("storageContainerReadListSas"u8);
                writer.WriteStringValue(StorageContainerReadListSas);
            }
            if (Optional.IsDefined(BlobPrefix))
            {
                writer.WritePropertyName("blobPrefix"u8);
                writer.WriteStringValue(BlobPrefix);
            }
            writer.WritePropertyName("relativeInputAssetPath"u8);
            writer.WriteStringValue(RelativeInputAssetPath);
            writer.WriteEndObject();
        }

        internal static AssetConversionInputOptions DeserializeAssetConversionInputOptions(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            Uri storageContainerUri = default;
            string storageContainerReadListSas = default;
            string blobPrefix = default;
            string relativeInputAssetPath = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("storageContainerUri"u8))
                {
                    storageContainerUri = new Uri(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("storageContainerReadListSas"u8))
                {
                    storageContainerReadListSas = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("blobPrefix"u8))
                {
                    blobPrefix = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("relativeInputAssetPath"u8))
                {
                    relativeInputAssetPath = property.Value.GetString();
                    continue;
                }
            }
            return new AssetConversionInputOptions(storageContainerUri, storageContainerReadListSas, blobPrefix, relativeInputAssetPath);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AssetConversionInputOptions FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAssetConversionInputOptions(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
