// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Relay.Models
{
    internal static partial class RelayTypeExtensions
    {
        public static string ToSerialString(this RelayType value) => value switch
        {
            RelayType.NetTcp => "NetTcp",
            RelayType.Http => "Http",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown RelayType value.")
        };

        public static RelayType ToRelayType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NetTcp")) return RelayType.NetTcp;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Http")) return RelayType.Http;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown RelayType value.");
        }
    }
}
