// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Relay.Models
{
    /// <summary> Name of this SKU. </summary>
    public readonly partial struct RelaySkuName : IEquatable<RelaySkuName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RelaySkuName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RelaySkuName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardValue = "Standard";

        /// <summary> Standard. </summary>
        public static RelaySkuName Standard { get; } = new RelaySkuName(StandardValue);
        /// <summary> Determines if two <see cref="RelaySkuName"/> values are the same. </summary>
        public static bool operator ==(RelaySkuName left, RelaySkuName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RelaySkuName"/> values are not the same. </summary>
        public static bool operator !=(RelaySkuName left, RelaySkuName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RelaySkuName"/>. </summary>
        public static implicit operator RelaySkuName(string value) => new RelaySkuName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RelaySkuName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RelaySkuName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
