// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Relay.Models
{
    /// <summary> Default Action for Network Rule Set. </summary>
    public readonly partial struct RelayNetworkRuleSetDefaultAction : IEquatable<RelayNetworkRuleSetDefaultAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RelayNetworkRuleSetDefaultAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RelayNetworkRuleSetDefaultAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "Allow";
        private const string DenyValue = "Deny";

        /// <summary> Allow. </summary>
        public static RelayNetworkRuleSetDefaultAction Allow { get; } = new RelayNetworkRuleSetDefaultAction(AllowValue);
        /// <summary> Deny. </summary>
        public static RelayNetworkRuleSetDefaultAction Deny { get; } = new RelayNetworkRuleSetDefaultAction(DenyValue);
        /// <summary> Determines if two <see cref="RelayNetworkRuleSetDefaultAction"/> values are the same. </summary>
        public static bool operator ==(RelayNetworkRuleSetDefaultAction left, RelayNetworkRuleSetDefaultAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RelayNetworkRuleSetDefaultAction"/> values are not the same. </summary>
        public static bool operator !=(RelayNetworkRuleSetDefaultAction left, RelayNetworkRuleSetDefaultAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RelayNetworkRuleSetDefaultAction"/>. </summary>
        public static implicit operator RelayNetworkRuleSetDefaultAction(string value) => new RelayNetworkRuleSetDefaultAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RelayNetworkRuleSetDefaultAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RelayNetworkRuleSetDefaultAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
