// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Relay.Models
{
    /// <summary> The IP Filter Action. </summary>
    public readonly partial struct RelayNetworkRuleIPAction : IEquatable<RelayNetworkRuleIPAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RelayNetworkRuleIPAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RelayNetworkRuleIPAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowValue = "Allow";

        /// <summary> Allow. </summary>
        public static RelayNetworkRuleIPAction Allow { get; } = new RelayNetworkRuleIPAction(AllowValue);
        /// <summary> Determines if two <see cref="RelayNetworkRuleIPAction"/> values are the same. </summary>
        public static bool operator ==(RelayNetworkRuleIPAction left, RelayNetworkRuleIPAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RelayNetworkRuleIPAction"/> values are not the same. </summary>
        public static bool operator !=(RelayNetworkRuleIPAction left, RelayNetworkRuleIPAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RelayNetworkRuleIPAction"/>. </summary>
        public static implicit operator RelayNetworkRuleIPAction(string value) => new RelayNetworkRuleIPAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RelayNetworkRuleIPAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RelayNetworkRuleIPAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
