// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.Relay.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableRelayArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableRelayArmClient"/> class for mocking. </summary>
        protected MockableRelayArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableRelayArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableRelayArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableRelayArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="RelayNamespaceAuthorizationRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RelayNamespaceAuthorizationRuleResource.CreateResourceIdentifier" /> to create a <see cref="RelayNamespaceAuthorizationRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RelayNamespaceAuthorizationRuleResource"/> object. </returns>
        public virtual RelayNamespaceAuthorizationRuleResource GetRelayNamespaceAuthorizationRuleResource(ResourceIdentifier id)
        {
            RelayNamespaceAuthorizationRuleResource.ValidateResourceId(id);
            return new RelayNamespaceAuthorizationRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="RelayHybridConnectionAuthorizationRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RelayHybridConnectionAuthorizationRuleResource.CreateResourceIdentifier" /> to create a <see cref="RelayHybridConnectionAuthorizationRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RelayHybridConnectionAuthorizationRuleResource"/> object. </returns>
        public virtual RelayHybridConnectionAuthorizationRuleResource GetRelayHybridConnectionAuthorizationRuleResource(ResourceIdentifier id)
        {
            RelayHybridConnectionAuthorizationRuleResource.ValidateResourceId(id);
            return new RelayHybridConnectionAuthorizationRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="WcfRelayAuthorizationRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="WcfRelayAuthorizationRuleResource.CreateResourceIdentifier" /> to create a <see cref="WcfRelayAuthorizationRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="WcfRelayAuthorizationRuleResource"/> object. </returns>
        public virtual WcfRelayAuthorizationRuleResource GetWcfRelayAuthorizationRuleResource(ResourceIdentifier id)
        {
            WcfRelayAuthorizationRuleResource.ValidateResourceId(id);
            return new WcfRelayAuthorizationRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="RelayNamespaceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RelayNamespaceResource.CreateResourceIdentifier" /> to create a <see cref="RelayNamespaceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RelayNamespaceResource"/> object. </returns>
        public virtual RelayNamespaceResource GetRelayNamespaceResource(ResourceIdentifier id)
        {
            RelayNamespaceResource.ValidateResourceId(id);
            return new RelayNamespaceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="RelayNetworkRuleSetResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RelayNetworkRuleSetResource.CreateResourceIdentifier" /> to create a <see cref="RelayNetworkRuleSetResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RelayNetworkRuleSetResource"/> object. </returns>
        public virtual RelayNetworkRuleSetResource GetRelayNetworkRuleSetResource(ResourceIdentifier id)
        {
            RelayNetworkRuleSetResource.ValidateResourceId(id);
            return new RelayNetworkRuleSetResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="RelayHybridConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RelayHybridConnectionResource.CreateResourceIdentifier" /> to create a <see cref="RelayHybridConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RelayHybridConnectionResource"/> object. </returns>
        public virtual RelayHybridConnectionResource GetRelayHybridConnectionResource(ResourceIdentifier id)
        {
            RelayHybridConnectionResource.ValidateResourceId(id);
            return new RelayHybridConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="WcfRelayResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="WcfRelayResource.CreateResourceIdentifier" /> to create a <see cref="WcfRelayResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="WcfRelayResource"/> object. </returns>
        public virtual WcfRelayResource GetWcfRelayResource(ResourceIdentifier id)
        {
            WcfRelayResource.ValidateResourceId(id);
            return new WcfRelayResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="RelayPrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RelayPrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create a <see cref="RelayPrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RelayPrivateEndpointConnectionResource"/> object. </returns>
        public virtual RelayPrivateEndpointConnectionResource GetRelayPrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            RelayPrivateEndpointConnectionResource.ValidateResourceId(id);
            return new RelayPrivateEndpointConnectionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="RelayPrivateLinkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="RelayPrivateLinkResource.CreateResourceIdentifier" /> to create a <see cref="RelayPrivateLinkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="RelayPrivateLinkResource"/> object. </returns>
        public virtual RelayPrivateLinkResource GetRelayPrivateLinkResource(ResourceIdentifier id)
        {
            RelayPrivateLinkResource.ValidateResourceId(id);
            return new RelayPrivateLinkResource(Client, id);
        }
    }
}
