// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Relay.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmRelayModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Relay.RelayAuthorizationRuleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="rights"> The rights associated with the rule. </param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <returns> A new <see cref="Relay.RelayAuthorizationRuleData"/> instance for mocking. </returns>
        public static RelayAuthorizationRuleData RelayAuthorizationRuleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IEnumerable<RelayAccessRight> rights = null, AzureLocation? location = null)
        {
            rights ??= new List<RelayAccessRight>();

            return new RelayAuthorizationRuleData(
                id,
                name,
                resourceType,
                systemData,
                rights?.ToList(),
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RelayAccessKeys"/>. </summary>
        /// <param name="primaryConnectionString"> Primary connection string of the created namespace authorization rule. </param>
        /// <param name="secondaryConnectionString"> Secondary connection string of the created namespace authorization rule. </param>
        /// <param name="primaryKey"> A base64-encoded 256-bit primary key for signing and validating the SAS token. </param>
        /// <param name="secondaryKey"> A base64-encoded 256-bit secondary key for signing and validating the SAS token. </param>
        /// <param name="keyName"> A string that describes the authorization rule. </param>
        /// <returns> A new <see cref="Models.RelayAccessKeys"/> instance for mocking. </returns>
        public static RelayAccessKeys RelayAccessKeys(string primaryConnectionString = null, string secondaryConnectionString = null, string primaryKey = null, string secondaryKey = null, string keyName = null)
        {
            return new RelayAccessKeys(
                primaryConnectionString,
                secondaryConnectionString,
                primaryKey,
                secondaryKey,
                keyName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RelayRegenerateAccessKeyContent"/>. </summary>
        /// <param name="keyType"> The access key to regenerate. </param>
        /// <param name="key"> Optional. If the key value is provided, this is set to key type, or autogenerated key value set for key type. </param>
        /// <returns> A new <see cref="Models.RelayRegenerateAccessKeyContent"/> instance for mocking. </returns>
        public static RelayRegenerateAccessKeyContent RelayRegenerateAccessKeyContent(RelayAccessKeyType keyType = default, string key = null)
        {
            return new RelayRegenerateAccessKeyContent(keyType, key, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Relay.RelayHybridConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="createdOn"> The time the hybrid connection was created. </param>
        /// <param name="updatedOn"> The time the namespace was updated. </param>
        /// <param name="listenerCount"> The number of listeners for this hybrid connection. Note that min : 1 and max:25 are supported. </param>
        /// <param name="isClientAuthorizationRequired"> Returns true if client authorization is needed for this hybrid connection; otherwise, false. </param>
        /// <param name="userMetadata"> The usermetadata is a placeholder to store user-defined string data for the hybrid connection endpoint. For example, it can be used to store descriptive data, such as a list of teams and their contact information. Also, user-defined configuration settings can be stored. </param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <returns> A new <see cref="Relay.RelayHybridConnectionData"/> instance for mocking. </returns>
        public static RelayHybridConnectionData RelayHybridConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? createdOn = null, DateTimeOffset? updatedOn = null, int? listenerCount = null, bool? isClientAuthorizationRequired = null, string userMetadata = null, AzureLocation? location = null)
        {
            return new RelayHybridConnectionData(
                id,
                name,
                resourceType,
                systemData,
                createdOn,
                updatedOn,
                listenerCount,
                isClientAuthorizationRequired,
                userMetadata,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RelayNameAvailabilityResult"/>. </summary>
        /// <param name="message"> The detailed info regarding the reason associated with the namespace. </param>
        /// <param name="isNameAvailable"> Value indicating namespace is available. Returns true if the namespace is available; otherwise, false. </param>
        /// <param name="reason"> The reason for unavailability of a namespace. </param>
        /// <returns> A new <see cref="Models.RelayNameAvailabilityResult"/> instance for mocking. </returns>
        public static RelayNameAvailabilityResult RelayNameAvailabilityResult(string message = null, bool? isNameAvailable = null, RelayNameUnavailableReason? reason = null)
        {
            return new RelayNameAvailabilityResult(message, isNameAvailable, reason, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Relay.RelayNamespaceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="sku"> SKU of the namespace. </param>
        /// <param name="provisioningState"> Provisioning state of the Namespace. </param>
        /// <param name="status"> Status of the Namespace. </param>
        /// <param name="createdOn"> The time the namespace was created. </param>
        /// <param name="updatedOn"> The time the namespace was updated. </param>
        /// <param name="serviceBusEndpoint"> Endpoint you can use to perform Service Bus operations. </param>
        /// <param name="metricId"> Identifier for Azure Insights metrics. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connections. </param>
        /// <param name="publicNetworkAccess"> This determines if traffic is allowed over public network. By default it is enabled. DO NOT USE PublicNetworkAccess on Namespace API. Please use the NetworkRuleSet API to enable or disable PublicNetworkAccess. </param>
        /// <returns> A new <see cref="Relay.RelayNamespaceData"/> instance for mocking. </returns>
        public static RelayNamespaceData RelayNamespaceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, RelaySku sku = null, string provisioningState = null, string status = null, DateTimeOffset? createdOn = null, DateTimeOffset? updatedOn = null, string serviceBusEndpoint = null, string metricId = null, IEnumerable<RelayPrivateEndpointConnectionData> privateEndpointConnections = null, RelayPublicNetworkAccess? publicNetworkAccess = null)
        {
            tags ??= new Dictionary<string, string>();
            privateEndpointConnections ??= new List<RelayPrivateEndpointConnectionData>();

            return new RelayNamespaceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                sku,
                provisioningState,
                status,
                createdOn,
                updatedOn,
                serviceBusEndpoint,
                metricId,
                privateEndpointConnections?.ToList(),
                publicNetworkAccess,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Relay.RelayPrivateEndpointConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="privateEndpointId"> The Private Endpoint resource for this Connection. </param>
        /// <param name="connectionState"> Details about the state of the connection. </param>
        /// <param name="provisioningState"> Provisioning state of the Private Endpoint Connection. </param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <returns> A new <see cref="Relay.RelayPrivateEndpointConnectionData"/> instance for mocking. </returns>
        public static RelayPrivateEndpointConnectionData RelayPrivateEndpointConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier privateEndpointId = null, RelayPrivateLinkServiceConnectionState connectionState = null, RelayPrivateEndpointConnectionProvisioningState? provisioningState = null, AzureLocation? location = null)
        {
            return new RelayPrivateEndpointConnectionData(
                id,
                name,
                resourceType,
                systemData,
                privateEndpointId != null ? ResourceManagerModelFactory.WritableSubResource(privateEndpointId) : null,
                connectionState,
                provisioningState,
                location,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RelayNamespacePatch"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="sku"> SKU of the namespace. </param>
        /// <param name="provisioningState"> Provisioning state of the Namespace. </param>
        /// <param name="status"> Status of the Namespace. </param>
        /// <param name="createdOn"> The time the namespace was created. </param>
        /// <param name="updatedOn"> The time the namespace was updated. </param>
        /// <param name="serviceBusEndpoint"> Endpoint you can use to perform Service Bus operations. </param>
        /// <param name="metricId"> Identifier for Azure Insights metrics. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connections. </param>
        /// <param name="publicNetworkAccess"> This determines if traffic is allowed over public network. By default it is enabled. DO NOT USE PublicNetworkAccess on Namespace API. Please use the NetworkRuleSet API to enable or disable PublicNetworkAccess. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <returns> A new <see cref="Models.RelayNamespacePatch"/> instance for mocking. </returns>
        public static RelayNamespacePatch RelayNamespacePatch(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, RelaySku sku = null, string provisioningState = null, string status = null, DateTimeOffset? createdOn = null, DateTimeOffset? updatedOn = null, string serviceBusEndpoint = null, string metricId = null, IEnumerable<RelayPrivateEndpointConnectionData> privateEndpointConnections = null, RelayPublicNetworkAccess? publicNetworkAccess = null, IDictionary<string, string> tags = null)
        {
            privateEndpointConnections ??= new List<RelayPrivateEndpointConnectionData>();
            tags ??= new Dictionary<string, string>();

            return new RelayNamespacePatch(
                id,
                name,
                resourceType,
                systemData,
                sku,
                provisioningState,
                status,
                createdOn,
                updatedOn,
                serviceBusEndpoint,
                metricId,
                privateEndpointConnections?.ToList(),
                publicNetworkAccess,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Relay.RelayPrivateLinkResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="groupId"> The private link resource group id. </param>
        /// <param name="requiredMembers"> The private link resource required member names. </param>
        /// <param name="requiredZoneNames"> The private link resource Private link DNS zone name. </param>
        /// <returns> A new <see cref="Relay.RelayPrivateLinkResourceData"/> instance for mocking. </returns>
        public static RelayPrivateLinkResourceData RelayPrivateLinkResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string groupId = null, IEnumerable<string> requiredMembers = null, IEnumerable<string> requiredZoneNames = null)
        {
            requiredMembers ??= new List<string>();
            requiredZoneNames ??= new List<string>();

            return new RelayPrivateLinkResourceData(
                id,
                name,
                resourceType,
                systemData,
                groupId,
                requiredMembers?.ToList(),
                requiredZoneNames?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Relay.RelayNetworkRuleSetData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="defaultAction"> Default Action for Network Rule Set. </param>
        /// <param name="publicNetworkAccess"> This determines if traffic is allowed over public network. By default it is enabled. </param>
        /// <param name="ipRules"> List of IpRules. </param>
        /// <returns> A new <see cref="Relay.RelayNetworkRuleSetData"/> instance for mocking. </returns>
        public static RelayNetworkRuleSetData RelayNetworkRuleSetData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, RelayNetworkRuleSetDefaultAction? defaultAction = null, RelayPublicNetworkAccess? publicNetworkAccess = null, IEnumerable<RelayNetworkRuleSetIPRule> ipRules = null)
        {
            ipRules ??= new List<RelayNetworkRuleSetIPRule>();

            return new RelayNetworkRuleSetData(
                id,
                name,
                resourceType,
                systemData,
                defaultAction,
                publicNetworkAccess,
                ipRules?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Relay.WcfRelayData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="isDynamic"> Returns true if the relay is dynamic; otherwise, false. </param>
        /// <param name="createdOn"> The time the WCF relay was created. </param>
        /// <param name="updatedOn"> The time the namespace was updated. </param>
        /// <param name="listenerCount"> The number of listeners for this relay. Note that min :1 and max:25 are supported. </param>
        /// <param name="relayType"> WCF relay type. </param>
        /// <param name="isClientAuthorizationRequired"> Returns true if client authorization is needed for this relay; otherwise, false. </param>
        /// <param name="isTransportSecurityRequired"> Returns true if transport security is needed for this relay; otherwise, false. </param>
        /// <param name="userMetadata"> The usermetadata is a placeholder to store user-defined string data for the WCF Relay endpoint. For example, it can be used to store descriptive data, such as list of teams and their contact information. Also, user-defined configuration settings can be stored. </param>
        /// <param name="location"> The geo-location where the resource lives. </param>
        /// <returns> A new <see cref="Relay.WcfRelayData"/> instance for mocking. </returns>
        public static WcfRelayData WcfRelayData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, bool? isDynamic = null, DateTimeOffset? createdOn = null, DateTimeOffset? updatedOn = null, int? listenerCount = null, RelayType? relayType = null, bool? isClientAuthorizationRequired = null, bool? isTransportSecurityRequired = null, string userMetadata = null, AzureLocation? location = null)
        {
            return new WcfRelayData(
                id,
                name,
                resourceType,
                systemData,
                isDynamic,
                createdOn,
                updatedOn,
                listenerCount,
                relayType,
                isClientAuthorizationRequired,
                isTransportSecurityRequired,
                userMetadata,
                location,
                serializedAdditionalRawData: null);
        }
    }
}
