// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Relay.Samples
{
    public partial class Sample_RelayPrivateLinkResource
    {
        // NameSpacePrivateEndPointConnectionGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_NameSpacePrivateEndPointConnectionGet()
        {
            // Generated from example definition: specification/relay/resource-manager/Microsoft.Relay/stable/2021-11-01/examples/PrivateEndpointConnections/PrivateLinkResourcesGet.json
            // this example is just showing the usage of "PrivateLinkResources_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RelayPrivateLinkResource created on azure
            // for more information of creating RelayPrivateLinkResource, please refer to the document of RelayPrivateLinkResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "resourcegroup";
            string namespaceName = "example-RelayNamespace-5849";
            string privateLinkResourceName = "{PrivateLinkResource name}";
            ResourceIdentifier relayPrivateLinkResourceId = RelayPrivateLinkResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, privateLinkResourceName);
            RelayPrivateLinkResource relayPrivateLinkResource = client.GetRelayPrivateLinkResource(relayPrivateLinkResourceId);

            // invoke the operation
            RelayPrivateLinkResource result = await relayPrivateLinkResource.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RelayPrivateLinkResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
