// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Relay.Models;

namespace Azure.ResourceManager.Relay.Samples
{
    public partial class Sample_RelayHybridConnectionAuthorizationRuleResource
    {
        // RelayHybridConnectionAuthorizationRuleCreate
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_RelayHybridConnectionAuthorizationRuleCreate()
        {
            // Generated from example definition: specification/relay/resource-manager/Microsoft.Relay/stable/2021-11-01/examples/HybridConnection/RelayHybridConnectionAuthorizationRuleCreate.json
            // this example is just showing the usage of "HybridConnections_CreateOrUpdateAuthorizationRule" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RelayHybridConnectionAuthorizationRuleResource created on azure
            // for more information of creating RelayHybridConnectionAuthorizationRuleResource, please refer to the document of RelayHybridConnectionAuthorizationRuleResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "resourcegroup";
            string namespaceName = "example-RelayNamespace-01";
            string hybridConnectionName = "example-Relay-Hybrid-01";
            string authorizationRuleName = "example-RelayAuthRules-01";
            ResourceIdentifier relayHybridConnectionAuthorizationRuleResourceId = RelayHybridConnectionAuthorizationRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, hybridConnectionName, authorizationRuleName);
            RelayHybridConnectionAuthorizationRuleResource relayHybridConnectionAuthorizationRule = client.GetRelayHybridConnectionAuthorizationRuleResource(relayHybridConnectionAuthorizationRuleResourceId);

            // invoke the operation
            RelayAuthorizationRuleData data = new RelayAuthorizationRuleData()
            {
                Rights =
{
RelayAccessRight.Listen,RelayAccessRight.Send
},
            };
            ArmOperation<RelayHybridConnectionAuthorizationRuleResource> lro = await relayHybridConnectionAuthorizationRule.UpdateAsync(WaitUntil.Completed, data);
            RelayHybridConnectionAuthorizationRuleResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RelayAuthorizationRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // RelayHybridConnectionAuthorizationRuleDelete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_RelayHybridConnectionAuthorizationRuleDelete()
        {
            // Generated from example definition: specification/relay/resource-manager/Microsoft.Relay/stable/2021-11-01/examples/HybridConnection/RelayHybridConnectionAuthorizationRuleDelete.json
            // this example is just showing the usage of "HybridConnections_DeleteAuthorizationRule" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RelayHybridConnectionAuthorizationRuleResource created on azure
            // for more information of creating RelayHybridConnectionAuthorizationRuleResource, please refer to the document of RelayHybridConnectionAuthorizationRuleResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "resourcegroup";
            string namespaceName = "example-RelayNamespace-01";
            string hybridConnectionName = "example-Relay-Hybrid-01";
            string authorizationRuleName = "example-RelayAuthRules-01";
            ResourceIdentifier relayHybridConnectionAuthorizationRuleResourceId = RelayHybridConnectionAuthorizationRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, hybridConnectionName, authorizationRuleName);
            RelayHybridConnectionAuthorizationRuleResource relayHybridConnectionAuthorizationRule = client.GetRelayHybridConnectionAuthorizationRuleResource(relayHybridConnectionAuthorizationRuleResourceId);

            // invoke the operation
            await relayHybridConnectionAuthorizationRule.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // RelayHybridConnectionAuthorizationRuleGet
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RelayHybridConnectionAuthorizationRuleGet()
        {
            // Generated from example definition: specification/relay/resource-manager/Microsoft.Relay/stable/2021-11-01/examples/HybridConnection/RelayHybridConnectionAuthorizationRuleGet.json
            // this example is just showing the usage of "HybridConnections_GetAuthorizationRule" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RelayHybridConnectionAuthorizationRuleResource created on azure
            // for more information of creating RelayHybridConnectionAuthorizationRuleResource, please refer to the document of RelayHybridConnectionAuthorizationRuleResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "resourcegroup";
            string namespaceName = "example-RelayNamespace-01";
            string hybridConnectionName = "example-Relay-Hybrid-01";
            string authorizationRuleName = "example-RelayAuthRules-01";
            ResourceIdentifier relayHybridConnectionAuthorizationRuleResourceId = RelayHybridConnectionAuthorizationRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, hybridConnectionName, authorizationRuleName);
            RelayHybridConnectionAuthorizationRuleResource relayHybridConnectionAuthorizationRule = client.GetRelayHybridConnectionAuthorizationRuleResource(relayHybridConnectionAuthorizationRuleResourceId);

            // invoke the operation
            RelayHybridConnectionAuthorizationRuleResource result = await relayHybridConnectionAuthorizationRule.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            RelayAuthorizationRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // RelayHybridConnectionAuthorizationRuleListKey
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetKeys_RelayHybridConnectionAuthorizationRuleListKey()
        {
            // Generated from example definition: specification/relay/resource-manager/Microsoft.Relay/stable/2021-11-01/examples/HybridConnection/RelayHybridConnectionAuthorizationRuleListKey.json
            // this example is just showing the usage of "HybridConnections_ListKeys" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RelayHybridConnectionAuthorizationRuleResource created on azure
            // for more information of creating RelayHybridConnectionAuthorizationRuleResource, please refer to the document of RelayHybridConnectionAuthorizationRuleResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "resourcegroup";
            string namespaceName = "example-RelayNamespace-01";
            string hybridConnectionName = "example-Relay-Hybrid-01";
            string authorizationRuleName = "example-RelayAuthRules-01";
            ResourceIdentifier relayHybridConnectionAuthorizationRuleResourceId = RelayHybridConnectionAuthorizationRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, hybridConnectionName, authorizationRuleName);
            RelayHybridConnectionAuthorizationRuleResource relayHybridConnectionAuthorizationRule = client.GetRelayHybridConnectionAuthorizationRuleResource(relayHybridConnectionAuthorizationRuleResourceId);

            // invoke the operation
            RelayAccessKeys result = await relayHybridConnectionAuthorizationRule.GetKeysAsync();

            Console.WriteLine($"Succeeded: {result}");
        }

        // RelayHybridConnectionAuthorizationRuleRegenerateKey
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RegenerateKeys_RelayHybridConnectionAuthorizationRuleRegenerateKey()
        {
            // Generated from example definition: specification/relay/resource-manager/Microsoft.Relay/stable/2021-11-01/examples/HybridConnection/RelayHybridConnectionAuthorizationRuleRegenerateKey.json
            // this example is just showing the usage of "HybridConnections_RegenerateKeys" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this RelayHybridConnectionAuthorizationRuleResource created on azure
            // for more information of creating RelayHybridConnectionAuthorizationRuleResource, please refer to the document of RelayHybridConnectionAuthorizationRuleResource
            string subscriptionId = "ffffffff-ffff-ffff-ffff-ffffffffffff";
            string resourceGroupName = "resourcegroup";
            string namespaceName = "example-RelayNamespace-01";
            string hybridConnectionName = "example-Relay-Hybrid-01";
            string authorizationRuleName = "example-RelayAuthRules-01";
            ResourceIdentifier relayHybridConnectionAuthorizationRuleResourceId = RelayHybridConnectionAuthorizationRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, namespaceName, hybridConnectionName, authorizationRuleName);
            RelayHybridConnectionAuthorizationRuleResource relayHybridConnectionAuthorizationRule = client.GetRelayHybridConnectionAuthorizationRuleResource(relayHybridConnectionAuthorizationRuleResourceId);

            // invoke the operation
            RelayRegenerateAccessKeyContent content = new RelayRegenerateAccessKeyContent(RelayAccessKeyType.PrimaryKey);
            RelayAccessKeys result = await relayHybridConnectionAuthorizationRule.RegenerateKeysAsync(content);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
