// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RedisEnterprise.Models
{
    /// <summary> Explains the current redundancy strategy of the cluster, which affects the expected SLA. </summary>
    public readonly partial struct RedisEnterpriseRedundancyMode : IEquatable<RedisEnterpriseRedundancyMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RedisEnterpriseRedundancyMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RedisEnterpriseRedundancyMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string LRValue = "LR";
        private const string ZRValue = "ZR";

        /// <summary> No redundancy. Availability loss will occur. </summary>
        public static RedisEnterpriseRedundancyMode None { get; } = new RedisEnterpriseRedundancyMode(NoneValue);
        /// <summary> Local redundancy with high availability. </summary>
        public static RedisEnterpriseRedundancyMode LR { get; } = new RedisEnterpriseRedundancyMode(LRValue);
        /// <summary> Zone redundant. Higher availability. </summary>
        public static RedisEnterpriseRedundancyMode ZR { get; } = new RedisEnterpriseRedundancyMode(ZRValue);
        /// <summary> Determines if two <see cref="RedisEnterpriseRedundancyMode"/> values are the same. </summary>
        public static bool operator ==(RedisEnterpriseRedundancyMode left, RedisEnterpriseRedundancyMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RedisEnterpriseRedundancyMode"/> values are not the same. </summary>
        public static bool operator !=(RedisEnterpriseRedundancyMode left, RedisEnterpriseRedundancyMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RedisEnterpriseRedundancyMode"/>. </summary>
        public static implicit operator RedisEnterpriseRedundancyMode(string value) => new RedisEnterpriseRedundancyMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RedisEnterpriseRedundancyMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RedisEnterpriseRedundancyMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
