// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RedisEnterprise.Models
{
    /// <summary> Current provisioning status. </summary>
    public readonly partial struct RedisEnterpriseProvisioningStatus : IEquatable<RedisEnterpriseProvisioningStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RedisEnterpriseProvisioningStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RedisEnterpriseProvisioningStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";

        /// <summary> Succeeded. </summary>
        public static RedisEnterpriseProvisioningStatus Succeeded { get; } = new RedisEnterpriseProvisioningStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static RedisEnterpriseProvisioningStatus Failed { get; } = new RedisEnterpriseProvisioningStatus(FailedValue);
        /// <summary> Canceled. </summary>
        public static RedisEnterpriseProvisioningStatus Canceled { get; } = new RedisEnterpriseProvisioningStatus(CanceledValue);
        /// <summary> Creating. </summary>
        public static RedisEnterpriseProvisioningStatus Creating { get; } = new RedisEnterpriseProvisioningStatus(CreatingValue);
        /// <summary> Updating. </summary>
        public static RedisEnterpriseProvisioningStatus Updating { get; } = new RedisEnterpriseProvisioningStatus(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static RedisEnterpriseProvisioningStatus Deleting { get; } = new RedisEnterpriseProvisioningStatus(DeletingValue);
        /// <summary> Determines if two <see cref="RedisEnterpriseProvisioningStatus"/> values are the same. </summary>
        public static bool operator ==(RedisEnterpriseProvisioningStatus left, RedisEnterpriseProvisioningStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RedisEnterpriseProvisioningStatus"/> values are not the same. </summary>
        public static bool operator !=(RedisEnterpriseProvisioningStatus left, RedisEnterpriseProvisioningStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RedisEnterpriseProvisioningStatus"/>. </summary>
        public static implicit operator RedisEnterpriseProvisioningStatus(string value) => new RedisEnterpriseProvisioningStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RedisEnterpriseProvisioningStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RedisEnterpriseProvisioningStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
