// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RedisEnterprise.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct RedisEnterprisePrivateEndpointConnectionProvisioningState : IEquatable<RedisEnterprisePrivateEndpointConnectionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RedisEnterprisePrivateEndpointConnectionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RedisEnterprisePrivateEndpointConnectionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";

        /// <summary> Succeeded. </summary>
        public static RedisEnterprisePrivateEndpointConnectionProvisioningState Succeeded { get; } = new RedisEnterprisePrivateEndpointConnectionProvisioningState(SucceededValue);
        /// <summary> Creating. </summary>
        public static RedisEnterprisePrivateEndpointConnectionProvisioningState Creating { get; } = new RedisEnterprisePrivateEndpointConnectionProvisioningState(CreatingValue);
        /// <summary> Deleting. </summary>
        public static RedisEnterprisePrivateEndpointConnectionProvisioningState Deleting { get; } = new RedisEnterprisePrivateEndpointConnectionProvisioningState(DeletingValue);
        /// <summary> Failed. </summary>
        public static RedisEnterprisePrivateEndpointConnectionProvisioningState Failed { get; } = new RedisEnterprisePrivateEndpointConnectionProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="RedisEnterprisePrivateEndpointConnectionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(RedisEnterprisePrivateEndpointConnectionProvisioningState left, RedisEnterprisePrivateEndpointConnectionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RedisEnterprisePrivateEndpointConnectionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(RedisEnterprisePrivateEndpointConnectionProvisioningState left, RedisEnterprisePrivateEndpointConnectionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RedisEnterprisePrivateEndpointConnectionProvisioningState"/>. </summary>
        public static implicit operator RedisEnterprisePrivateEndpointConnectionProvisioningState(string value) => new RedisEnterprisePrivateEndpointConnectionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RedisEnterprisePrivateEndpointConnectionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RedisEnterprisePrivateEndpointConnectionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
