// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.RedisEnterprise.Models
{
    /// <summary> Specifies details of a linked database resource. </summary>
    public partial class RedisEnterpriseLinkedDatabase
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RedisEnterpriseLinkedDatabase"/>. </summary>
        public RedisEnterpriseLinkedDatabase()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RedisEnterpriseLinkedDatabase"/>. </summary>
        /// <param name="id"> Resource ID of a database resource to link with this database. </param>
        /// <param name="state"> State of the link between the database resources. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RedisEnterpriseLinkedDatabase(ResourceIdentifier id, RedisEnterpriseDatabaseLinkState? state, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            State = state;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Resource ID of a database resource to link with this database. </summary>
        [WirePath("id")]
        public ResourceIdentifier Id { get; set; }
        /// <summary> State of the link between the database resources. </summary>
        [WirePath("state")]
        public RedisEnterpriseDatabaseLinkState? State { get; }
    }
}
