// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RedisEnterprise.Models
{
    /// <summary> Enabled by default. If highAvailability is disabled, the data set is not replicated. This affects the availability SLA, and increases the risk of data loss. </summary>
    public readonly partial struct RedisEnterpriseHighAvailability : IEquatable<RedisEnterpriseHighAvailability>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RedisEnterpriseHighAvailability"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RedisEnterpriseHighAvailability(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static RedisEnterpriseHighAvailability Enabled { get; } = new RedisEnterpriseHighAvailability(EnabledValue);
        /// <summary> Disabled. </summary>
        public static RedisEnterpriseHighAvailability Disabled { get; } = new RedisEnterpriseHighAvailability(DisabledValue);
        /// <summary> Determines if two <see cref="RedisEnterpriseHighAvailability"/> values are the same. </summary>
        public static bool operator ==(RedisEnterpriseHighAvailability left, RedisEnterpriseHighAvailability right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RedisEnterpriseHighAvailability"/> values are not the same. </summary>
        public static bool operator !=(RedisEnterpriseHighAvailability left, RedisEnterpriseHighAvailability right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RedisEnterpriseHighAvailability"/>. </summary>
        public static implicit operator RedisEnterpriseHighAvailability(string value) => new RedisEnterpriseHighAvailability(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RedisEnterpriseHighAvailability other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RedisEnterpriseHighAvailability other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
