// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RedisEnterprise.Models
{
    /// <summary> Redis eviction policy - default is VolatileLRU. </summary>
    public readonly partial struct RedisEnterpriseEvictionPolicy : IEquatable<RedisEnterpriseEvictionPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RedisEnterpriseEvictionPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RedisEnterpriseEvictionPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllKeysLfuValue = "AllKeysLFU";
        private const string AllKeysLruValue = "AllKeysLRU";
        private const string AllKeysRandomValue = "AllKeysRandom";
        private const string VolatileLruValue = "VolatileLRU";
        private const string VolatileLfuValue = "VolatileLFU";
        private const string VolatileTtlValue = "VolatileTTL";
        private const string VolatileRandomValue = "VolatileRandom";
        private const string NoEvictionValue = "NoEviction";

        /// <summary> AllKeysLFU. </summary>
        public static RedisEnterpriseEvictionPolicy AllKeysLfu { get; } = new RedisEnterpriseEvictionPolicy(AllKeysLfuValue);
        /// <summary> AllKeysLRU. </summary>
        public static RedisEnterpriseEvictionPolicy AllKeysLru { get; } = new RedisEnterpriseEvictionPolicy(AllKeysLruValue);
        /// <summary> AllKeysRandom. </summary>
        public static RedisEnterpriseEvictionPolicy AllKeysRandom { get; } = new RedisEnterpriseEvictionPolicy(AllKeysRandomValue);
        /// <summary> VolatileLRU. </summary>
        public static RedisEnterpriseEvictionPolicy VolatileLru { get; } = new RedisEnterpriseEvictionPolicy(VolatileLruValue);
        /// <summary> VolatileLFU. </summary>
        public static RedisEnterpriseEvictionPolicy VolatileLfu { get; } = new RedisEnterpriseEvictionPolicy(VolatileLfuValue);
        /// <summary> VolatileTTL. </summary>
        public static RedisEnterpriseEvictionPolicy VolatileTtl { get; } = new RedisEnterpriseEvictionPolicy(VolatileTtlValue);
        /// <summary> VolatileRandom. </summary>
        public static RedisEnterpriseEvictionPolicy VolatileRandom { get; } = new RedisEnterpriseEvictionPolicy(VolatileRandomValue);
        /// <summary> NoEviction. </summary>
        public static RedisEnterpriseEvictionPolicy NoEviction { get; } = new RedisEnterpriseEvictionPolicy(NoEvictionValue);
        /// <summary> Determines if two <see cref="RedisEnterpriseEvictionPolicy"/> values are the same. </summary>
        public static bool operator ==(RedisEnterpriseEvictionPolicy left, RedisEnterpriseEvictionPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RedisEnterpriseEvictionPolicy"/> values are not the same. </summary>
        public static bool operator !=(RedisEnterpriseEvictionPolicy left, RedisEnterpriseEvictionPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RedisEnterpriseEvictionPolicy"/>. </summary>
        public static implicit operator RedisEnterpriseEvictionPolicy(string value) => new RedisEnterpriseEvictionPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RedisEnterpriseEvictionPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RedisEnterpriseEvictionPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
