// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RedisEnterprise.Models
{
    /// <summary> State of the link between the database resources. </summary>
    public readonly partial struct RedisEnterpriseDatabaseLinkState : IEquatable<RedisEnterpriseDatabaseLinkState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RedisEnterpriseDatabaseLinkState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RedisEnterpriseDatabaseLinkState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LinkedValue = "Linked";
        private const string LinkingValue = "Linking";
        private const string UnlinkingValue = "Unlinking";
        private const string LinkFailedValue = "LinkFailed";
        private const string UnlinkFailedValue = "UnlinkFailed";

        /// <summary> Linked. </summary>
        public static RedisEnterpriseDatabaseLinkState Linked { get; } = new RedisEnterpriseDatabaseLinkState(LinkedValue);
        /// <summary> Linking. </summary>
        public static RedisEnterpriseDatabaseLinkState Linking { get; } = new RedisEnterpriseDatabaseLinkState(LinkingValue);
        /// <summary> Unlinking. </summary>
        public static RedisEnterpriseDatabaseLinkState Unlinking { get; } = new RedisEnterpriseDatabaseLinkState(UnlinkingValue);
        /// <summary> LinkFailed. </summary>
        public static RedisEnterpriseDatabaseLinkState LinkFailed { get; } = new RedisEnterpriseDatabaseLinkState(LinkFailedValue);
        /// <summary> UnlinkFailed. </summary>
        public static RedisEnterpriseDatabaseLinkState UnlinkFailed { get; } = new RedisEnterpriseDatabaseLinkState(UnlinkFailedValue);
        /// <summary> Determines if two <see cref="RedisEnterpriseDatabaseLinkState"/> values are the same. </summary>
        public static bool operator ==(RedisEnterpriseDatabaseLinkState left, RedisEnterpriseDatabaseLinkState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RedisEnterpriseDatabaseLinkState"/> values are not the same. </summary>
        public static bool operator !=(RedisEnterpriseDatabaseLinkState left, RedisEnterpriseDatabaseLinkState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RedisEnterpriseDatabaseLinkState"/>. </summary>
        public static implicit operator RedisEnterpriseDatabaseLinkState(string value) => new RedisEnterpriseDatabaseLinkState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RedisEnterpriseDatabaseLinkState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RedisEnterpriseDatabaseLinkState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
