// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RedisEnterprise.Models
{
    /// <summary> Only userAssignedIdentity is supported in this API version; other types may be supported in the future. </summary>
    public readonly partial struct RedisEnterpriseCustomerManagedKeyIdentityType : IEquatable<RedisEnterpriseCustomerManagedKeyIdentityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RedisEnterpriseCustomerManagedKeyIdentityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RedisEnterpriseCustomerManagedKeyIdentityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SystemAssignedIdentityValue = "systemAssignedIdentity";
        private const string UserAssignedIdentityValue = "userAssignedIdentity";

        /// <summary> systemAssignedIdentity. </summary>
        public static RedisEnterpriseCustomerManagedKeyIdentityType SystemAssignedIdentity { get; } = new RedisEnterpriseCustomerManagedKeyIdentityType(SystemAssignedIdentityValue);
        /// <summary> userAssignedIdentity. </summary>
        public static RedisEnterpriseCustomerManagedKeyIdentityType UserAssignedIdentity { get; } = new RedisEnterpriseCustomerManagedKeyIdentityType(UserAssignedIdentityValue);
        /// <summary> Determines if two <see cref="RedisEnterpriseCustomerManagedKeyIdentityType"/> values are the same. </summary>
        public static bool operator ==(RedisEnterpriseCustomerManagedKeyIdentityType left, RedisEnterpriseCustomerManagedKeyIdentityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RedisEnterpriseCustomerManagedKeyIdentityType"/> values are not the same. </summary>
        public static bool operator !=(RedisEnterpriseCustomerManagedKeyIdentityType left, RedisEnterpriseCustomerManagedKeyIdentityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RedisEnterpriseCustomerManagedKeyIdentityType"/>. </summary>
        public static implicit operator RedisEnterpriseCustomerManagedKeyIdentityType(string value) => new RedisEnterpriseCustomerManagedKeyIdentityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RedisEnterpriseCustomerManagedKeyIdentityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RedisEnterpriseCustomerManagedKeyIdentityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
