// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RedisEnterprise.Models
{
    /// <summary> Specifies whether redis clients can connect using TLS-encrypted or plaintext redis protocols. Default is TLS-encrypted. </summary>
    public readonly partial struct RedisEnterpriseClientProtocol : IEquatable<RedisEnterpriseClientProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RedisEnterpriseClientProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RedisEnterpriseClientProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EncryptedValue = "Encrypted";
        private const string PlainTextValue = "Plaintext";

        /// <summary> Encrypted. </summary>
        public static RedisEnterpriseClientProtocol Encrypted { get; } = new RedisEnterpriseClientProtocol(EncryptedValue);
        /// <summary> Plaintext. </summary>
        public static RedisEnterpriseClientProtocol PlainText { get; } = new RedisEnterpriseClientProtocol(PlainTextValue);
        /// <summary> Determines if two <see cref="RedisEnterpriseClientProtocol"/> values are the same. </summary>
        public static bool operator ==(RedisEnterpriseClientProtocol left, RedisEnterpriseClientProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RedisEnterpriseClientProtocol"/> values are not the same. </summary>
        public static bool operator !=(RedisEnterpriseClientProtocol left, RedisEnterpriseClientProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RedisEnterpriseClientProtocol"/>. </summary>
        public static implicit operator RedisEnterpriseClientProtocol(string value) => new RedisEnterpriseClientProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RedisEnterpriseClientProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RedisEnterpriseClientProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
