// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.RedisEnterprise.Models
{
    internal static partial class RedisEnterpriseAccessKeyTypeExtensions
    {
        public static string ToSerialString(this RedisEnterpriseAccessKeyType value) => value switch
        {
            RedisEnterpriseAccessKeyType.Primary => "Primary",
            RedisEnterpriseAccessKeyType.Secondary => "Secondary",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown RedisEnterpriseAccessKeyType value.")
        };

        public static RedisEnterpriseAccessKeyType ToRedisEnterpriseAccessKeyType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Primary")) return RedisEnterpriseAccessKeyType.Primary;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Secondary")) return RedisEnterpriseAccessKeyType.Secondary;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown RedisEnterpriseAccessKeyType value.");
        }
    }
}
