// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RedisEnterprise.Models
{
    /// <summary> Sets the frequency at which a snapshot of the database is created. </summary>
    public readonly partial struct PersistenceSettingRdbFrequency : IEquatable<PersistenceSettingRdbFrequency>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PersistenceSettingRdbFrequency"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PersistenceSettingRdbFrequency(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OneHourValue = "1h";
        private const string SixHoursValue = "6h";
        private const string TwelveHoursValue = "12h";

        /// <summary> 1h. </summary>
        public static PersistenceSettingRdbFrequency OneHour { get; } = new PersistenceSettingRdbFrequency(OneHourValue);
        /// <summary> 6h. </summary>
        public static PersistenceSettingRdbFrequency SixHours { get; } = new PersistenceSettingRdbFrequency(SixHoursValue);
        /// <summary> 12h. </summary>
        public static PersistenceSettingRdbFrequency TwelveHours { get; } = new PersistenceSettingRdbFrequency(TwelveHoursValue);
        /// <summary> Determines if two <see cref="PersistenceSettingRdbFrequency"/> values are the same. </summary>
        public static bool operator ==(PersistenceSettingRdbFrequency left, PersistenceSettingRdbFrequency right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PersistenceSettingRdbFrequency"/> values are not the same. </summary>
        public static bool operator !=(PersistenceSettingRdbFrequency left, PersistenceSettingRdbFrequency right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PersistenceSettingRdbFrequency"/>. </summary>
        public static implicit operator PersistenceSettingRdbFrequency(string value) => new PersistenceSettingRdbFrequency(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PersistenceSettingRdbFrequency other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PersistenceSettingRdbFrequency other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
