// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RedisEnterprise.Models
{
    /// <summary> Sets the frequency at which data is written to disk. Defaults to '1s', meaning 'every second'. Note that the 'always' setting is deprecated, because of its performance impact. </summary>
    public readonly partial struct PersistenceSettingAofFrequency : IEquatable<PersistenceSettingAofFrequency>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PersistenceSettingAofFrequency"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PersistenceSettingAofFrequency(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OneSecondValue = "1s";
        private const string AlwaysValue = "always";

        /// <summary> 1s. </summary>
        public static PersistenceSettingAofFrequency OneSecond { get; } = new PersistenceSettingAofFrequency(OneSecondValue);
        /// <summary> always. </summary>
        public static PersistenceSettingAofFrequency Always { get; } = new PersistenceSettingAofFrequency(AlwaysValue);
        /// <summary> Determines if two <see cref="PersistenceSettingAofFrequency"/> values are the same. </summary>
        public static bool operator ==(PersistenceSettingAofFrequency left, PersistenceSettingAofFrequency right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PersistenceSettingAofFrequency"/> values are not the same. </summary>
        public static bool operator !=(PersistenceSettingAofFrequency left, PersistenceSettingAofFrequency right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PersistenceSettingAofFrequency"/>. </summary>
        public static implicit operator PersistenceSettingAofFrequency(string value) => new PersistenceSettingAofFrequency(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PersistenceSettingAofFrequency other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PersistenceSettingAofFrequency other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
