// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.RedisEnterprise.Models
{
    /// <summary> Parameters for reconfiguring active geo-replication, of an existing database that was previously unlinked from a replication group. </summary>
    public partial class ForceLinkContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ForceLinkContent"/>. </summary>
        /// <param name="groupNickname"> The name of the group of linked database resources. This should match the existing replication group name. </param>
        /// <param name="linkedDatabases"> The resource IDs of the databases that are expected to be linked and included in the replication group. This parameter is used to validate that the linking is to the expected (unlinked) part of the replication group, if it is splintered. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="groupNickname"/> or <paramref name="linkedDatabases"/> is null. </exception>
        public ForceLinkContent(string groupNickname, IEnumerable<RedisEnterpriseLinkedDatabase> linkedDatabases)
        {
            Argument.AssertNotNull(groupNickname, nameof(groupNickname));
            Argument.AssertNotNull(linkedDatabases, nameof(linkedDatabases));

            GroupNickname = groupNickname;
            LinkedDatabases = linkedDatabases.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="ForceLinkContent"/>. </summary>
        /// <param name="groupNickname"> The name of the group of linked database resources. This should match the existing replication group name. </param>
        /// <param name="linkedDatabases"> The resource IDs of the databases that are expected to be linked and included in the replication group. This parameter is used to validate that the linking is to the expected (unlinked) part of the replication group, if it is splintered. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ForceLinkContent(string groupNickname, IList<RedisEnterpriseLinkedDatabase> linkedDatabases, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            GroupNickname = groupNickname;
            LinkedDatabases = linkedDatabases;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ForceLinkContent"/> for deserialization. </summary>
        internal ForceLinkContent()
        {
        }

        /// <summary> The name of the group of linked database resources. This should match the existing replication group name. </summary>
        [WirePath("groupNickname")]
        public string GroupNickname { get; }
        /// <summary> The resource IDs of the databases that are expected to be linked and included in the replication group. This parameter is used to validate that the linking is to the expected (unlinked) part of the replication group, if it is splintered. </summary>
        [WirePath("linkedDatabases")]
        public IList<RedisEnterpriseLinkedDatabase> LinkedDatabases { get; }
    }
}
