// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.RedisEnterprise.Models
{
    /// <summary> Option to defer upgrade when newest version is released - default is NotDeferred. Learn more: https://aka.ms/redisversionupgrade. </summary>
    public readonly partial struct DeferUpgradeSetting : IEquatable<DeferUpgradeSetting>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeferUpgradeSetting"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeferUpgradeSetting(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeferredValue = "Deferred";
        private const string NotDeferredValue = "NotDeferred";

        /// <summary> Deferred. </summary>
        public static DeferUpgradeSetting Deferred { get; } = new DeferUpgradeSetting(DeferredValue);
        /// <summary> NotDeferred. </summary>
        public static DeferUpgradeSetting NotDeferred { get; } = new DeferUpgradeSetting(NotDeferredValue);
        /// <summary> Determines if two <see cref="DeferUpgradeSetting"/> values are the same. </summary>
        public static bool operator ==(DeferUpgradeSetting left, DeferUpgradeSetting right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeferUpgradeSetting"/> values are not the same. </summary>
        public static bool operator !=(DeferUpgradeSetting left, DeferUpgradeSetting right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeferUpgradeSetting"/>. </summary>
        public static implicit operator DeferUpgradeSetting(string value) => new DeferUpgradeSetting(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeferUpgradeSetting other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeferUpgradeSetting other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
